/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.extendeddevices;

import de.joergjahnke.common.emulation.WaveDataProducer;
import de.joergjahnke.common.util.Observer;
import java.io.ByteArrayOutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class WavePlayer
implements Observer {
    private static final int NOTIFY_THRESHOLD_BUFFERSIZE = 256;
    private SourceDataLine dataLine;
    private Thread datalineWriterThread = null;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public WavePlayer(WaveDataProducer producer) {
        try {
            AudioFormat audioFormat = new AudioFormat(producer.getSampleRate(), producer.getBitsPerSample(), producer.getChannels(), true, false);
            DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, audioFormat);
            this.dataLine = (SourceDataLine)AudioSystem.getLine(dataLineInfo);
            this.dataLine.open(this.dataLine.getFormat());
            this.dataLine.start();
            this.datalineWriterThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (WavePlayer.this.dataLine.isOpen()) {
                        byte[] data = WavePlayer.this.buffer.toByteArray();
                        WavePlayer.this.dataLine.write(data, 0, data.length);
                        ByteArrayOutputStream byteArrayOutputStream = WavePlayer.this.buffer;
                        synchronized (byteArrayOutputStream) {
                            WavePlayer.this.buffer.reset();
                            try {
                                WavePlayer.this.buffer.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
            };
            this.datalineWriterThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        this.dataLine.stop();
        this.dataLine.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object observed, Object obj) {
        if (null != this.dataLine && observed instanceof WaveDataProducer) {
            byte[] data = (byte[])obj;
            ByteArrayOutputStream byteArrayOutputStream = this.buffer;
            synchronized (byteArrayOutputStream) {
                this.buffer.write(data, 0, data.length);
                if (this.buffer.size() > 256) {
                    this.buffer.notifyAll();
                }
            }
        }
    }
}

