/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.swing;

import de.joergjahnke.c64.core.C1541;
import de.joergjahnke.c64.core.C64;
import de.joergjahnke.c64.drive.DriveHandler;
import de.joergjahnke.c64.extendeddevices.EmulatorUtils;
import de.joergjahnke.c64.swing.C64Canvas;
import de.joergjahnke.common.extendeddevices.WavePlayer;
import de.joergjahnke.common.util.Observer;
import de.joergjahnke.common.vmabstraction.sunvm.SunVMResourceLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URI;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C64Frame
extends JFrame
implements Observer {
    private static final String VERSION = "1.10.4";
    private static final String URL_ONLINE_HELP = "http://sourceforge.net/apps/mediawiki/jmec64/index.php?title=JSwing_C64_Online_Help";
    private static final String PROJECT_PAGE_URL = "https://sourceforge.net/projects/jmec64/";
    private static final String SNAPSHOT_EXTENSION = ".snapshot";
    private static final int STATUS_NOTHING_LOADED = 0;
    private static final int STATUS_LOAD_OK = 1;
    private static final int STATUS_LOAD_FAILED = 2;
    private static final String NO_IMAGE = "no_image.c64";
    private static final String PROPERTIES_NAME = "JSwingC64.properties.xml";
    private static final String SUSPENDFILE_NAME = "JSwingC64.suspend";
    private static final String ICON_NAME = "/res/jme/J64_sm.png";
    private static final String SETTING_WINDOW_SCALING = "WindowScaling";
    private static final String SETTING_MOUSE_USAGE = "MouseUsage";
    private static final String SETTING_JOYSTICK_PORT = "JoystickPort";
    private static final String SETTING_IMAGE_DIRECTORY = "ImageDirectory";
    private static final String SETTING_DRIVE_MODE = "DriveMode";
    private static final String SETTING_FRAMESKIP = "FrameSkip";
    private static final Set<String> FILE_EXTENSIONS = new HashSet<String>(Arrays.asList(".d64", ".t64", ".prg", ".p00"));
    private static final int CLEAR_DRIVE_STATE_TIME = 1000;
    private final C64Canvas canvas;
    private C64 c64 = null;
    private File lastFile = null;
    private Timer statusMessageTimer = null;
    private Timer driveStateTimer = null;
    private TimerTask driveInactiveTask = null;
    private Integer currentDriveState = null;
    private final Properties settings = new Properties();
    private boolean automaticTurboMode = true;
    private final Hashtable attachedImages = new Hashtable();
    private final ResourceBundle c64Resources = ResourceBundle.getBundle("res/l10n/c64EmulatorMessages");
    private final ResourceBundle commonResources = ResourceBundle.getBundle("res/l10n/commonMessages");
    private ButtonGroup buttonGroupDriveModes;
    private ButtonGroup buttonGroupFrameSkipSelections;
    private ButtonGroup buttonGroupJoystickPorts;
    private ButtonGroup buttonGroupMouseEmulation;
    private ButtonGroup buttonGroupScreenSizes;
    private ButtonGroup buttonGroupTurboModes;
    private JLabel jLabelDrives;
    private JLabel jLabelMessages;
    private JLabel jLabelPerformance;
    private JLabel jLabelTrackSector;
    private JMenu jMenuAutoStart;
    private JMenuBar jMenuBar;
    private JMenu jMenuDriveMode;
    private JMenu jMenuEmulation;
    private JMenu jMenuFile;
    private JMenu jMenuFrameskip;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItemAbout;
    private JMenuItem jMenuItemAttachImage;
    private JMenuItem jMenuItemAutoStart;
    private JRadioButtonMenuItem jMenuItemBalancedC1541;
    private JRadioButtonMenuItem jMenuItemCompatibleC1541;
    private JMenuItem jMenuItemContents;
    private JMenuItem jMenuItemDetachImages;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemFastAutoStart;
    private JRadioButtonMenuItem jMenuItemFastC1541;
    private JMenuItem jMenuItemFastLoadProgram;
    private JRadioButtonMenuItem jMenuItemFrameSkip1;
    private JRadioButtonMenuItem jMenuItemFrameSkip2;
    private JRadioButtonMenuItem jMenuItemFrameSkip3;
    private JRadioButtonMenuItem jMenuItemFrameSkip4;
    private JRadioButtonMenuItem jMenuItemFrameSkipAuto;
    private JMenuItem jMenuItemLoadProgram;
    private JMenuItem jMenuItemReset;
    private JMenuItem jMenuItemRun;
    private JMenuItem jMenuItemSaveSnapshot;
    private JMenuItem jMenuItemShowLog;
    private JRadioButtonMenuItem jMenuItemSizeX1;
    private JRadioButtonMenuItem jMenuItemSizeX2;
    private JRadioButtonMenuItem jMenuItemSizeX3;
    private JMenuItem jMenuItemSpecialKey;
    private JMenuItem jMenuItemSuspend;
    private JMenuItem jMenuItemTypeText;
    private JMenu jMenuJoystick;
    private JMenu jMenuJoystickPort;
    private JMenu jMenuLoadProgram;
    private JMenu jMenuMouseAsJoystick;
    private JMenu jMenuSelectDrive;
    private JMenu jMenuSize;
    private JMenu jMenuTurboMode;
    private JPanel jPanelDrive;
    private JPanel jPanelStatus;
    private JRadioButtonMenuItem jRadioButtonMenuItemJoystickPort1;
    private JRadioButtonMenuItem jRadioButtonMenuItemJoystickPort2;
    private JRadioButtonMenuItem jRadioButtonMenuItemMouseFireButtonEmulation;
    private JRadioButtonMenuItem jRadioButtonMenuItemNoMouseJoystickEmulation;
    private JRadioButtonMenuItem jRadioButtonMenuItemTurboModeAuto;
    private JRadioButtonMenuItem jRadioButtonMenuItemTurboModeOff;
    private JRadioButtonMenuItem jRadioButtonMenuItemTurboModeOn;
    private JRadioButtonMenuItem jRadioButtonMenuItemVirtualJoystick;
    private JSeparator jSeparatorEmulationMenu1;
    private JSeparator jSeparatorEmulationMenu2;
    private JSeparator jSeparatorFileMenu1;
    private JSeparator jSeparatorFileMenu2;
    private JRadioButtonMenuItem[] jCheckBoxMenuItemSelectedDrives;

    public C64Frame() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.settings.loadFromXML(new FileInputStream(new File(PROPERTIES_NAME)));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.initComponents();
        this.jCheckBoxMenuItemSelectedDrives = new JRadioButtonMenuItem[4];
        for (int i = 0; i < 4; ++i) {
            this.jCheckBoxMenuItemSelectedDrives[i] = new JRadioButtonMenuItem(i + " (#" + (i + 8) + ")");
            this.jCheckBoxMenuItemSelectedDrives[i].setSelected(i == 0);
            this.jCheckBoxMenuItemSelectedDrives[i].addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    C64Frame.this.jCheckBoxMenuItemSelectDriveItemStateChanged(evt);
                }
            });
            this.jMenuSelectDrive.add(this.jCheckBoxMenuItemSelectedDrives[i]);
        }
        try {
            this.setIconImage(this.getToolkit().getImage(this.getClass().getResource(ICON_NAME)));
        }
        catch (SecurityException e) {
            // empty catch block
        }
        this.canvas = new C64Canvas();
        try {
            this.c64 = new C64(new SunVMResourceLoader());
            this.canvas.setC64(this.c64);
            int frameskip = Integer.parseInt(this.settings.getProperty(SETTING_FRAMESKIP, "0"));
            switch (frameskip) {
                case 1: {
                    this.jMenuItemFrameSkip1ActionPerformed(null);
                    break;
                }
                case 2: {
                    this.jMenuItemFrameSkip2ActionPerformed(null);
                    break;
                }
                case 3: {
                    this.jMenuItemFrameSkip3ActionPerformed(null);
                    break;
                }
                case 4: {
                    this.jMenuItemFrameSkip4ActionPerformed(null);
                    break;
                }
                default: {
                    this.jMenuItemFrameSkipAutoActionPerformed(null);
                }
            }
            this.c64.getSID().addObserver(new WavePlayer(this.c64.getSID()));
            this.getContentPane().add((Component)this.canvas, "Center");
            int scaling = Integer.parseInt(this.settings.getProperty(SETTING_WINDOW_SCALING, "1"));
            switch (scaling) {
                case 1: {
                    this.jMenuItemSizeX1ActionPerformed(null);
                    break;
                }
                case 2: {
                    this.jMenuItemSizeX2ActionPerformed(null);
                    break;
                }
                case 3: {
                    this.jMenuItemSizeX3ActionPerformed(null);
                }
            }
            int level = Integer.parseInt(this.settings.getProperty(SETTING_DRIVE_MODE, Integer.toString(50)));
            switch (level) {
                case 0: {
                    this.jMenuItemFastC1541ActionPerformed(null);
                    break;
                }
                case 50: {
                    this.jMenuItemBalancedC1541ActionPerformed(null);
                    break;
                }
                case 100: {
                    this.jMenuItemCompatibleC1541ActionPerformed(null);
                }
            }
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
            this.setResizable(false);
            this.c64.getLogger().addObserver(this);
            for (int i = 0; i < 4; ++i) {
                this.c64.getDrive(i).addObserver(this);
            }
            this.c64.addObserver(this);
            this.resume();
            new Thread(this.c64).start();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(this.commonResources.getString("CouldNotInitialize") + e);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                try {
                    C64Frame.this.settings.storeToXML(new FileOutputStream(new File(C64Frame.PROPERTIES_NAME)), "Properties for JSwingC64");
                    C64Frame.this.c64.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        switch (Integer.parseInt(this.settings.getProperty(SETTING_MOUSE_USAGE, Integer.toString(1)))) {
            case 2: {
                this.jRadioButtonMenuItemVirtualJoystickActionPerformed(null);
                break;
            }
            case 1: {
                this.jRadioButtonMenuItemMouseFireButtonEmulationActionPerformed(null);
                break;
            }
            case 0: {
                this.jRadioButtonMenuItemNoMouseJoystickEmulationActionPerformed(null);
            }
        }
        switch (Integer.parseInt(this.settings.getProperty(SETTING_JOYSTICK_PORT, "0"))) {
            case 0: {
                this.jRadioButtonMenuItemJoystickPort1ActionPerformed(null);
                break;
            }
            case 1: {
                this.jRadioButtonMenuItemJoystickPort2ActionPerformed(null);
            }
        }
    }

    private void attachImage(int driveNo, String programFilename) {
        File programFile = new File(programFilename);
        if (!(programFile != null && programFile.exists() || this.settings.getProperty(SETTING_IMAGE_DIRECTORY) == null)) {
            programFile = new File(new File(this.settings.getProperty(SETTING_IMAGE_DIRECTORY)), programFilename);
        }
        if (programFile == null || !programFile.exists()) {
            JOptionPane.showMessageDialog(this, this.commonResources.getString("ROMFileCannotBeFound") + " " + programFilename + "!\n" + this.commonResources.getString("PleasePickCorrectROMFile"), this.commonResources.getString("ROMFileNotFound"), 2);
            String filename = this.pickImage(FILE_EXTENSIONS);
            if (filename == null) {
                return;
            }
            programFile = new File(filename);
        }
        this.lastFile = programFile;
        this.settings.setProperty(SETTING_IMAGE_DIRECTORY, programFile.getParentFile().getAbsolutePath());
        try {
            this.lastFile = EmulatorUtils.attachImage(this.c64, this.c64.getActiveDrive(), programFile.getAbsolutePath());
            this.attachedImages.put(new Integer(driveNo), programFile.getAbsolutePath());
            this.jMenuLoadProgram.setEnabled(true);
            this.jMenuItemDetachImages.setEnabled(true);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, this.c64Resources.getString("CouldNotLoadFile") + ": " + programFile.getAbsolutePath() + "!\n" + e, this.c64Resources.getString("CouldNotLoadFile"), 0);
        }
    }

    private void detachImages() {
        for (int i = 0; i < 4; ++i) {
            this.c64.getDrive(i).detachImage();
        }
        this.attachedImages.clear();
        this.jMenuLoadProgram.setEnabled(false);
        this.jMenuItemDetachImages.setEnabled(false);
    }

    private void runProgram() {
        this.c64.getKeyboard().textTyped("run");
        this.c64.getKeyboard().keyTyped("ENTER");
    }

    private boolean selectImage() {
        HashSet<String> extensions = new HashSet<String>(FILE_EXTENSIONS);
        extensions.add(SNAPSHOT_EXTENSION);
        extensions.add(".gzd");
        String filename = this.pickImage(extensions);
        boolean wasImageSelected = false;
        if (null != filename) {
            if (filename.endsWith(SNAPSHOT_EXTENSION)) {
                this.runSnapshot(filename);
            } else {
                this.attachImage(this.c64.getActiveDrive(), filename);
                wasImageSelected = true;
            }
            this.settings.setProperty(SETTING_IMAGE_DIRECTORY, this.lastFile.getParentFile().getAbsolutePath());
        }
        return wasImageSelected;
    }

    private boolean saveState(String filename) {
        this.c64.pause();
        File suspend = new File(filename);
        DataOutputStream out = null;
        boolean wasSuccessful = false;
        try {
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(suspend)));
            out.writeInt(this.attachedImages.size());
            Enumeration en = this.attachedImages.keys();
            while (en.hasMoreElements()) {
                Integer driveNo = (Integer)en.nextElement();
                out.writeInt(driveNo);
                out.writeUTF(this.attachedImages.get(driveNo).toString());
            }
            this.c64.serialize(out);
            out.close();
            wasSuccessful = true;
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this, this.commonResources.getString("FailedToStoreState") + "\n" + t, this.commonResources.getString("SuspendFailed"), 2);
            t.printStackTrace();
            try {
                out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            suspend.delete();
            this.c64.resume();
        }
        return wasSuccessful;
    }

    private void suspend() {
        boolean wasSuspended = this.saveState(SUSPENDFILE_NAME);
        if (wasSuspended) {
            this.setVisible(false);
            System.exit(0);
        } else {
            JOptionPane.showMessageDialog(this, this.commonResources.getString("FailedToStoreState"), this.commonResources.getString("SuspendFailed"), 2);
        }
    }

    private void saveSnapshot() {
        DateFormat format = DateFormat.getDateTimeInstance(3, 2);
        String filename = null == this.lastFile ? NO_IMAGE : this.lastFile.getAbsolutePath();
        filename = filename.substring(0, filename.lastIndexOf(46));
        filename = filename + " ";
        filename = filename + format.format(new Date()).replaceAll("\\:", "");
        boolean wasSaved = this.saveState(filename = filename + SNAPSHOT_EXTENSION);
        if (wasSaved) {
            this.c64.resume();
        } else {
            JOptionPane.showMessageDialog(this, this.commonResources.getString("FailedToStoreState"), this.commonResources.getString("SavingSnapshotFailed"), 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadState(String filename) {
        this.c64.pause();
        boolean hasSuspendData = false;
        int status = 0;
        File suspend = new File(filename);
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(suspend)));
            hasSuspendData = true;
            int size = ((DataInputStream)in).readInt();
            for (int i = 0; i < size; ++i) {
                int driveNo = ((DataInputStream)in).readInt();
                String program = ((DataInputStream)in).readUTF();
                this.attachImage(driveNo, program);
            }
            this.c64.deserialize((DataInputStream)in);
            status = 1;
        }
        catch (Throwable t) {
            if (hasSuspendData) {
                status = 2;
                t.printStackTrace();
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        this.c64.resume();
        return status;
    }

    private void resume() {
        int status = this.loadState(SUSPENDFILE_NAME);
        if (status == 1 || status == 2) {
            try {
                new File(SUSPENDFILE_NAME).delete();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Could not remove the suspend file! Please remove the suspend file 'JSwingC64.suspend' manually.", this.commonResources.getString("CouldNotRemoveSuspendData"), 0);
                e.printStackTrace();
            }
        }
        switch (status) {
            case 1: {
                break;
            }
            case 2: {
                JOptionPane.showMessageDialog(this, this.commonResources.getString("FailedToRestoreState"), this.commonResources.getString("ResumeFailed"), 0);
            }
        }
    }

    private void runSnapshot(String filename) {
        int status = this.loadState(filename);
        switch (status) {
            case 1: {
                break;
            }
            case 2: {
                JOptionPane.showMessageDialog(this, this.commonResources.getString("FailedToRestoreState"), this.commonResources.getString("LoadSnapshotFailed"), 0);
            }
        }
    }

    private String pickImage(final Collection<String> extensions) {
        JFileChooser fileChooser = new JFileChooser(){

            public boolean accept(File f) {
                boolean isAccepted = f.isDirectory();
                for (String ext : extensions) {
                    isAccepted |= f.getName().toLowerCase().endsWith(ext);
                }
                return isAccepted;
            }
        };
        if (this.lastFile != null) {
            fileChooser.setCurrentDirectory(this.lastFile.getParentFile());
        } else if (this.settings.getProperty(SETTING_IMAGE_DIRECTORY) != null) {
            fileChooser.setCurrentDirectory(new File(this.settings.getProperty(SETTING_IMAGE_DIRECTORY)));
        }
        if (fileChooser.showOpenDialog(this) == 0) {
            return fileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    private void initComponents() {
        this.buttonGroupTurboModes = new ButtonGroup();
        this.buttonGroupDriveModes = new ButtonGroup();
        this.buttonGroupScreenSizes = new ButtonGroup();
        this.buttonGroupFrameSkipSelections = new ButtonGroup();
        this.buttonGroupJoystickPorts = new ButtonGroup();
        this.buttonGroupMouseEmulation = new ButtonGroup();
        this.jPanelStatus = new JPanel();
        this.jLabelPerformance = new JLabel();
        this.jLabelMessages = new JLabel();
        this.jPanelDrive = new JPanel();
        this.jLabelTrackSector = new JLabel();
        this.jLabelDrives = new JLabel();
        this.jMenuBar = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuAutoStart = new JMenu();
        this.jMenuItemAutoStart = new JMenuItem();
        this.jMenuItemFastAutoStart = new JMenuItem();
        this.jSeparatorFileMenu1 = new JSeparator();
        this.jMenuItemAttachImage = new JMenuItem();
        this.jMenuItemDetachImages = new JMenuItem();
        this.jMenuLoadProgram = new JMenu();
        this.jMenuItemLoadProgram = new JMenuItem();
        this.jMenuItemFastLoadProgram = new JMenuItem();
        this.jMenuItemSaveSnapshot = new JMenuItem();
        this.jMenuSelectDrive = new JMenu();
        this.jSeparatorFileMenu2 = new JSeparator();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuItemSuspend = new JMenuItem();
        this.jMenuEmulation = new JMenu();
        this.jMenuItemTypeText = new JMenuItem();
        this.jMenuItemSpecialKey = new JMenuItem();
        this.jMenuItemRun = new JMenuItem();
        this.jSeparatorEmulationMenu1 = new JSeparator();
        this.jMenuJoystick = new JMenu();
        this.jMenuJoystickPort = new JMenu();
        this.jRadioButtonMenuItemJoystickPort1 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemJoystickPort2 = new JRadioButtonMenuItem();
        this.jMenuMouseAsJoystick = new JMenu();
        this.jRadioButtonMenuItemNoMouseJoystickEmulation = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemMouseFireButtonEmulation = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemVirtualJoystick = new JRadioButtonMenuItem();
        this.jMenuDriveMode = new JMenu();
        this.jMenuItemFastC1541 = new JRadioButtonMenuItem();
        this.jMenuItemBalancedC1541 = new JRadioButtonMenuItem();
        this.jMenuItemCompatibleC1541 = new JRadioButtonMenuItem();
        this.jMenuSize = new JMenu();
        this.jMenuItemSizeX1 = new JRadioButtonMenuItem();
        this.jMenuItemSizeX2 = new JRadioButtonMenuItem();
        this.jMenuItemSizeX3 = new JRadioButtonMenuItem();
        this.jMenuFrameskip = new JMenu();
        this.jMenuItemFrameSkipAuto = new JRadioButtonMenuItem();
        this.jMenuItemFrameSkip1 = new JRadioButtonMenuItem();
        this.jMenuItemFrameSkip2 = new JRadioButtonMenuItem();
        this.jMenuItemFrameSkip3 = new JRadioButtonMenuItem();
        this.jMenuItemFrameSkip4 = new JRadioButtonMenuItem();
        this.jMenuTurboMode = new JMenu();
        this.jRadioButtonMenuItemTurboModeAuto = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemTurboModeOn = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemTurboModeOff = new JRadioButtonMenuItem();
        this.jSeparatorEmulationMenu2 = new JSeparator();
        this.jMenuItemReset = new JMenuItem();
        this.jMenuItemShowLog = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuItemAbout = new JMenuItem();
        this.jMenuItemContents = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("JSwingC64");
        this.setResizable(false);
        this.jPanelStatus.setLayout(new BorderLayout());
        this.jLabelPerformance.setFont(new Font("Arial", 0, 10));
        this.jLabelPerformance.setHorizontalAlignment(0);
        this.jLabelPerformance.setText("      ");
        ResourceBundle bundle = ResourceBundle.getBundle("res/l10n/c64EmulatorMessages");
        this.jLabelPerformance.setToolTipText(bundle.getString("PerformancePanelTooltip"));
        this.jLabelPerformance.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelPerformance.setOpaque(true);
        this.jLabelPerformance.setPreferredSize(new Dimension(45, 17));
        this.jPanelStatus.add((Component)this.jLabelPerformance, "West");
        this.jLabelMessages.setFont(new Font("Arial", 0, 10));
        this.jLabelMessages.setHorizontalAlignment(2);
        this.jLabelMessages.setToolTipText(bundle.getString("MessagePanelTooltip"));
        this.jLabelMessages.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelStatus.add((Component)this.jLabelMessages, "Center");
        this.jPanelDrive.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelDrive.setMinimumSize(new Dimension(30, 18));
        this.jPanelDrive.setPreferredSize(new Dimension(50, 18));
        this.jPanelDrive.setLayout(new BorderLayout());
        this.jLabelTrackSector.setFont(new Font("Arial", 0, 10));
        this.jLabelTrackSector.setHorizontalAlignment(0);
        this.jLabelTrackSector.setToolTipText(bundle.getString("TrackSectorPanelTooltip"));
        this.jPanelDrive.add((Component)this.jLabelTrackSector, "Center");
        this.jLabelDrives.setIcon(new ImageIcon(this.getClass().getResource("/res/swing/LED_inactive.gif")));
        this.jLabelDrives.setToolTipText(bundle.getString("DriveIsInactive"));
        this.jPanelDrive.add((Component)this.jLabelDrives, "East");
        this.jPanelStatus.add((Component)this.jPanelDrive, "East");
        this.getContentPane().add((Component)this.jPanelStatus, "South");
        ResourceBundle bundle1 = ResourceBundle.getBundle("res/l10n/commonMessages");
        this.jMenuFile.setText(bundle1.getString("File"));
        this.jMenuAutoStart.setText(bundle.getString("AutoStart2"));
        this.jMenuAutoStart.setToolTipText(bundle.getString("AutoStart2Tooltip"));
        this.jMenuItemAutoStart.setAccelerator(KeyStroke.getKeyStroke(65, 10));
        this.jMenuItemAutoStart.setText(bundle.getString("AutoStart"));
        this.jMenuItemAutoStart.setToolTipText(bundle.getString("AutoStartToolTip"));
        this.jMenuItemAutoStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemAutoStartActionPerformed(evt);
            }
        });
        this.jMenuAutoStart.add(this.jMenuItemAutoStart);
        this.jMenuItemFastAutoStart.setAccelerator(KeyStroke.getKeyStroke(70, 10));
        this.jMenuItemFastAutoStart.setText(bundle.getString("FastAutoStart"));
        this.jMenuItemFastAutoStart.setToolTipText(bundle.getString("FastAutoStartToolTip"));
        this.jMenuItemFastAutoStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemFastAutoStartActionPerformed(evt);
            }
        });
        this.jMenuAutoStart.add(this.jMenuItemFastAutoStart);
        this.jMenuFile.add(this.jMenuAutoStart);
        this.jMenuFile.add(this.jSeparatorFileMenu1);
        this.jMenuItemAttachImage.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        this.jMenuItemAttachImage.setText(bundle.getString("AttachImage"));
        this.jMenuItemAttachImage.setToolTipText(bundle.getString("AttachImageTooltip"));
        this.jMenuItemAttachImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemAttachImageActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemAttachImage);
        this.jMenuItemDetachImages.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        this.jMenuItemDetachImages.setText(bundle.getString("DetachAll"));
        this.jMenuItemDetachImages.setToolTipText(bundle.getString("DetachAllTooltip"));
        this.jMenuItemDetachImages.setEnabled(false);
        this.jMenuItemDetachImages.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemDetachImagesActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemDetachImages);
        this.jMenuLoadProgram.setText(bundle.getString("LoadProgram"));
        this.jMenuLoadProgram.setToolTipText(bundle.getString("LoadProgramTooltip"));
        this.jMenuLoadProgram.setEnabled(false);
        this.jMenuItemLoadProgram.setAccelerator(KeyStroke.getKeyStroke(76, 8));
        this.jMenuItemLoadProgram.setText(bundle.getString("Load"));
        this.jMenuItemLoadProgram.setToolTipText(bundle.getString("LoadProgramTooltip"));
        this.jMenuItemLoadProgram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemLoadProgramActionPerformed(evt);
            }
        });
        this.jMenuLoadProgram.add(this.jMenuItemLoadProgram);
        this.jMenuItemFastLoadProgram.setAccelerator(KeyStroke.getKeyStroke(70, 8));
        this.jMenuItemFastLoadProgram.setText(bundle.getString("FastLoad"));
        this.jMenuItemFastLoadProgram.setToolTipText(bundle.getString("FastLoadProgramTooltip"));
        this.jMenuItemFastLoadProgram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemLoadProgramActionPerformed(evt);
            }
        });
        this.jMenuLoadProgram.add(this.jMenuItemFastLoadProgram);
        this.jMenuFile.add(this.jMenuLoadProgram);
        this.jMenuItemSaveSnapshot.setAccelerator(KeyStroke.getKeyStroke(83, 10));
        this.jMenuItemSaveSnapshot.setText(bundle1.getString("SaveSnapshot"));
        this.jMenuItemSaveSnapshot.setToolTipText(bundle1.getString("SaveSnapshotTooltip"));
        this.jMenuItemSaveSnapshot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemSaveSnapshotActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSaveSnapshot);
        this.jMenuSelectDrive.setText(bundle.getString("SelectDrive"));
        this.jMenuSelectDrive.setToolTipText(bundle.getString("SelectDriveTooltip"));
        this.jMenuFile.add(this.jMenuSelectDrive);
        this.jMenuFile.add(this.jSeparatorFileMenu2);
        this.jMenuItemExit.setText(bundle1.getString("Exit"));
        this.jMenuItemExit.setToolTipText(bundle1.getString("ExitTooltip"));
        this.jMenuItemExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuItemSuspend.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        this.jMenuItemSuspend.setText(bundle1.getString("Suspend"));
        this.jMenuItemSuspend.setToolTipText(bundle1.getString("SuspendTooltip"));
        this.jMenuItemSuspend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemSuspendActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSuspend);
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuEmulation.setText(bundle1.getString("Emulation"));
        this.jMenuItemTypeText.setAccelerator(KeyStroke.getKeyStroke(84, 8));
        this.jMenuItemTypeText.setText(bundle.getString("TypeText2"));
        this.jMenuItemTypeText.setToolTipText(bundle.getString("TypeText2Tooltip"));
        this.jMenuItemTypeText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemTypeTextActionPerformed(evt);
            }
        });
        this.jMenuEmulation.add(this.jMenuItemTypeText);
        this.jMenuItemSpecialKey.setAccelerator(KeyStroke.getKeyStroke(75, 8));
        this.jMenuItemSpecialKey.setText(bundle.getString("SpecialKeys2"));
        this.jMenuItemSpecialKey.setToolTipText(bundle.getString("SpecialKeys2Tooltip"));
        this.jMenuItemSpecialKey.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemSpecialKeyActionPerformed(evt);
            }
        });
        this.jMenuEmulation.add(this.jMenuItemSpecialKey);
        this.jMenuItemRun.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        this.jMenuItemRun.setText(bundle.getString("RunCurrent"));
        this.jMenuItemRun.setToolTipText(bundle.getString("RunCurrentTooltip"));
        this.jMenuItemRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemRunActionPerformed(evt);
            }
        });
        this.jMenuEmulation.add(this.jMenuItemRun);
        this.jMenuEmulation.add(this.jSeparatorEmulationMenu1);
        this.jMenuJoystick.setText(bundle.getString("Joystick"));
        this.jMenuJoystick.setToolTipText(bundle.getString("JoystickTooltip"));
        this.jMenuJoystickPort.setText(bundle.getString("Port"));
        this.jRadioButtonMenuItemJoystickPort1.setAccelerator(KeyStroke.getKeyStroke(49, 8));
        this.buttonGroupJoystickPorts.add(this.jRadioButtonMenuItemJoystickPort1);
        this.jRadioButtonMenuItemJoystickPort1.setSelected(true);
        this.jRadioButtonMenuItemJoystickPort1.setText("1");
        this.jRadioButtonMenuItemJoystickPort1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jRadioButtonMenuItemJoystickPort1ActionPerformed(evt);
            }
        });
        this.jMenuJoystickPort.add(this.jRadioButtonMenuItemJoystickPort1);
        this.jRadioButtonMenuItemJoystickPort2.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        this.buttonGroupJoystickPorts.add(this.jRadioButtonMenuItemJoystickPort2);
        this.jRadioButtonMenuItemJoystickPort2.setText("2");
        this.jRadioButtonMenuItemJoystickPort2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jRadioButtonMenuItemJoystickPort2ActionPerformed(evt);
            }
        });
        this.jMenuJoystickPort.add(this.jRadioButtonMenuItemJoystickPort2);
        this.jMenuJoystick.add(this.jMenuJoystickPort);
        this.jMenuMouseAsJoystick.setText(bundle.getString("EmulationViaMouse"));
        this.buttonGroupMouseEmulation.add(this.jRadioButtonMenuItemNoMouseJoystickEmulation);
        this.jRadioButtonMenuItemNoMouseJoystickEmulation.setText(bundle.getString("EmulationViaMouseNone"));
        this.jRadioButtonMenuItemNoMouseJoystickEmulation.setToolTipText(bundle.getString("EmulationViaMouseNoneTooltip"));
        this.jRadioButtonMenuItemNoMouseJoystickEmulation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jRadioButtonMenuItemNoMouseJoystickEmulationActionPerformed(evt);
            }
        });
        this.jMenuMouseAsJoystick.add(this.jRadioButtonMenuItemNoMouseJoystickEmulation);
        this.buttonGroupMouseEmulation.add(this.jRadioButtonMenuItemMouseFireButtonEmulation);
        this.jRadioButtonMenuItemMouseFireButtonEmulation.setSelected(true);
        this.jRadioButtonMenuItemMouseFireButtonEmulation.setText(bundle.getString("EmulationViaMouseButtonOnly"));
        this.jRadioButtonMenuItemMouseFireButtonEmulation.setToolTipText(bundle.getString("EmulationViaMouseButtonOnlyTooltip"));
        this.jRadioButtonMenuItemMouseFireButtonEmulation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jRadioButtonMenuItemMouseFireButtonEmulationActionPerformed(evt);
            }
        });
        this.jMenuMouseAsJoystick.add(this.jRadioButtonMenuItemMouseFireButtonEmulation);
        this.buttonGroupMouseEmulation.add(this.jRadioButtonMenuItemVirtualJoystick);
        this.jRadioButtonMenuItemVirtualJoystick.setText(bundle.getString("EmulationViaMouseFull"));
        this.jRadioButtonMenuItemVirtualJoystick.setToolTipText(bundle.getString("EmulationViaMouseFullTooltip"));
        this.jRadioButtonMenuItemVirtualJoystick.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jRadioButtonMenuItemVirtualJoystickActionPerformed(evt);
            }
        });
        this.jMenuMouseAsJoystick.add(this.jRadioButtonMenuItemVirtualJoystick);
        this.jMenuJoystick.add(this.jMenuMouseAsJoystick);
        this.jMenuEmulation.add(this.jMenuJoystick);
        this.jMenuDriveMode.setText(bundle.getString("C1541Mode"));
        this.jMenuDriveMode.setToolTipText(bundle.getString("C1541ModeTooltip"));
        this.buttonGroupDriveModes.add(this.jMenuItemFastC1541);
        this.jMenuItemFastC1541.setText(bundle.getString("Fast"));
        this.jMenuItemFastC1541.setToolTipText(bundle.getString("FastTooltip"));
        this.jMenuItemFastC1541.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemFastC1541ActionPerformed(evt);
            }
        });
        this.jMenuDriveMode.add(this.jMenuItemFastC1541);
        this.buttonGroupDriveModes.add(this.jMenuItemBalancedC1541);
        this.jMenuItemBalancedC1541.setText(bundle.getString("Balanced"));
        this.jMenuItemBalancedC1541.setToolTipText(bundle.getString("BalancedTooltip"));
        this.jMenuItemBalancedC1541.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemBalancedC1541ActionPerformed(evt);
            }
        });
        this.jMenuDriveMode.add(this.jMenuItemBalancedC1541);
        this.buttonGroupDriveModes.add(this.jMenuItemCompatibleC1541);
        this.jMenuItemCompatibleC1541.setText(bundle.getString("Compatible"));
        this.jMenuItemCompatibleC1541.setToolTipText(bundle.getString("CompatibleTooltip"));
        this.jMenuItemCompatibleC1541.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemCompatibleC1541ActionPerformed(evt);
            }
        });
        this.jMenuDriveMode.add(this.jMenuItemCompatibleC1541);
        this.jMenuEmulation.add(this.jMenuDriveMode);
        this.jMenuSize.setText(bundle1.getString("Size"));
        this.jMenuSize.setToolTipText(bundle1.getString("SizeTooltip"));
        this.jMenuItemSizeX1.setAccelerator(KeyStroke.getKeyStroke(49, 9));
        this.buttonGroupScreenSizes.add(this.jMenuItemSizeX1);
        this.jMenuItemSizeX1.setText("100%");
        this.jMenuItemSizeX1.setToolTipText(bundle.getString("Size100Tooltip"));
        this.jMenuItemSizeX1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemSizeX1ActionPerformed(evt);
            }
        });
        this.jMenuSize.add(this.jMenuItemSizeX1);
        this.jMenuItemSizeX2.setAccelerator(KeyStroke.getKeyStroke(50, 9));
        this.buttonGroupScreenSizes.add(this.jMenuItemSizeX2);
        this.jMenuItemSizeX2.setText("200%");
        this.jMenuItemSizeX2.setToolTipText(bundle.getString("Size200Tooltip"));
        this.jMenuItemSizeX2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemSizeX2ActionPerformed(evt);
            }
        });
        this.jMenuSize.add(this.jMenuItemSizeX2);
        this.jMenuItemSizeX3.setAccelerator(KeyStroke.getKeyStroke(51, 9));
        this.buttonGroupScreenSizes.add(this.jMenuItemSizeX3);
        this.jMenuItemSizeX3.setText("300%");
        this.jMenuItemSizeX3.setToolTipText(bundle.getString("Size300Tooltip"));
        this.jMenuItemSizeX3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemSizeX3ActionPerformed(evt);
            }
        });
        this.jMenuSize.add(this.jMenuItemSizeX3);
        this.jMenuEmulation.add(this.jMenuSize);
        this.jMenuFrameskip.setText(bundle1.getString("SkipFrames"));
        this.jMenuFrameskip.setToolTipText(bundle1.getString("SkipFramesTooltip"));
        this.buttonGroupFrameSkipSelections.add(this.jMenuItemFrameSkipAuto);
        this.jMenuItemFrameSkipAuto.setText(bundle.getString("Automatic"));
        this.jMenuItemFrameSkipAuto.setToolTipText(bundle.getString("AutomaticTooltip"));
        this.jMenuItemFrameSkipAuto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemFrameSkipAutoActionPerformed(evt);
            }
        });
        this.jMenuFrameskip.add(this.jMenuItemFrameSkipAuto);
        this.buttonGroupFrameSkipSelections.add(this.jMenuItemFrameSkip1);
        this.jMenuItemFrameSkip1.setText("1");
        this.jMenuItemFrameSkip1.setToolTipText(bundle1.getString("SkipFrames1Tooltip"));
        this.jMenuItemFrameSkip1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemFrameSkip1ActionPerformed(evt);
            }
        });
        this.jMenuFrameskip.add(this.jMenuItemFrameSkip1);
        this.buttonGroupFrameSkipSelections.add(this.jMenuItemFrameSkip2);
        this.jMenuItemFrameSkip2.setText("2");
        this.jMenuItemFrameSkip2.setToolTipText(bundle1.getString("SkipFrames2Tooltip"));
        this.jMenuItemFrameSkip2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemFrameSkip2ActionPerformed(evt);
            }
        });
        this.jMenuFrameskip.add(this.jMenuItemFrameSkip2);
        this.buttonGroupFrameSkipSelections.add(this.jMenuItemFrameSkip3);
        this.jMenuItemFrameSkip3.setText("3");
        this.jMenuItemFrameSkip3.setToolTipText(bundle1.getString("SkipFrames3Tooltip"));
        this.jMenuItemFrameSkip3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemFrameSkip3ActionPerformed(evt);
            }
        });
        this.jMenuFrameskip.add(this.jMenuItemFrameSkip3);
        this.buttonGroupFrameSkipSelections.add(this.jMenuItemFrameSkip4);
        this.jMenuItemFrameSkip4.setText("4");
        this.jMenuItemFrameSkip4.setToolTipText(bundle1.getString("SkipFrames4Tooltip"));
        this.jMenuItemFrameSkip4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemFrameSkip4ActionPerformed(evt);
            }
        });
        this.jMenuFrameskip.add(this.jMenuItemFrameSkip4);
        this.jMenuEmulation.add(this.jMenuFrameskip);
        this.jMenuTurboMode.setText(bundle.getString("TurboMode"));
        this.jMenuTurboMode.setToolTipText(bundle.getString("TurboModeTooltip"));
        this.jRadioButtonMenuItemTurboModeAuto.setAccelerator(KeyStroke.getKeyStroke(520, 8));
        this.buttonGroupTurboModes.add(this.jRadioButtonMenuItemTurboModeAuto);
        this.jRadioButtonMenuItemTurboModeAuto.setSelected(true);
        this.jRadioButtonMenuItemTurboModeAuto.setText(bundle.getString("Automatic"));
        this.jRadioButtonMenuItemTurboModeAuto.setToolTipText(bundle.getString("TurboModeAutoTooltip"));
        this.jRadioButtonMenuItemTurboModeAuto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jRadioButtonMenuItemTurboModeAutoActionPerformed(evt);
            }
        });
        this.jMenuTurboMode.add(this.jRadioButtonMenuItemTurboModeAuto);
        this.jRadioButtonMenuItemTurboModeOn.setAccelerator(KeyStroke.getKeyStroke(521, 8));
        this.buttonGroupTurboModes.add(this.jRadioButtonMenuItemTurboModeOn);
        this.jRadioButtonMenuItemTurboModeOn.setText(bundle1.getString("On"));
        this.jRadioButtonMenuItemTurboModeOn.setToolTipText(bundle.getString("TurboModeOnTooltip"));
        this.jRadioButtonMenuItemTurboModeOn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jRadioButtonMenuItemTurboModeOnActionPerformed(evt);
            }
        });
        this.jMenuTurboMode.add(this.jRadioButtonMenuItemTurboModeOn);
        this.jRadioButtonMenuItemTurboModeOff.setAccelerator(KeyStroke.getKeyStroke(45, 8));
        this.buttonGroupTurboModes.add(this.jRadioButtonMenuItemTurboModeOff);
        this.jRadioButtonMenuItemTurboModeOff.setText(bundle1.getString("Off"));
        this.jRadioButtonMenuItemTurboModeOff.setToolTipText(bundle.getString("TurboModeOffTooltip"));
        this.jRadioButtonMenuItemTurboModeOff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jRadioButtonMenuItemTurboModeOffActionPerformed(evt);
            }
        });
        this.jMenuTurboMode.add(this.jRadioButtonMenuItemTurboModeOff);
        this.jMenuEmulation.add(this.jMenuTurboMode);
        this.jMenuEmulation.add(this.jSeparatorEmulationMenu2);
        this.jMenuItemReset.setText(bundle.getString("ResetC64"));
        this.jMenuItemReset.setToolTipText(bundle.getString("ResetC64Tooltip"));
        this.jMenuItemReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemResetActionPerformed(evt);
            }
        });
        this.jMenuEmulation.add(this.jMenuItemReset);
        this.jMenuItemShowLog.setText(bundle1.getString("ShowLog"));
        this.jMenuItemShowLog.setToolTipText(bundle1.getString("ShowLogTooltip"));
        this.jMenuItemShowLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemShowLogActionPerformed(evt);
            }
        });
        this.jMenuEmulation.add(this.jMenuItemShowLog);
        this.jMenuBar.add(this.jMenuEmulation);
        this.jMenuHelp.setText(bundle1.getString("Help"));
        this.jMenuItemAbout.setText(bundle1.getString("About"));
        this.jMenuItemAbout.setToolTipText(bundle1.getString("AboutTooltip"));
        this.jMenuItemAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemAboutActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemAbout);
        this.jMenuItemContents.setAccelerator(KeyStroke.getKeyStroke(112, 8));
        this.jMenuItemContents.setText(bundle1.getString("Contents"));
        this.jMenuItemContents.setToolTipText(bundle1.getString("ContentsTooltip"));
        this.jMenuItemContents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemContentsActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemContents);
        this.jMenuBar.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar);
        this.pack();
    }

    private void jRadioButtonMenuItemVirtualJoystickActionPerformed(ActionEvent evt) {
        this.canvas.setMouseUsage(2);
        this.settings.setProperty(SETTING_MOUSE_USAGE, Integer.toString(2));
        this.jRadioButtonMenuItemVirtualJoystick.setSelected(true);
    }

    private void jRadioButtonMenuItemMouseFireButtonEmulationActionPerformed(ActionEvent evt) {
        this.canvas.setMouseUsage(1);
        this.settings.setProperty(SETTING_MOUSE_USAGE, Integer.toString(1));
        this.jRadioButtonMenuItemMouseFireButtonEmulation.setSelected(true);
    }

    private void jRadioButtonMenuItemNoMouseJoystickEmulationActionPerformed(ActionEvent evt) {
        this.canvas.setMouseUsage(0);
        this.settings.setProperty(SETTING_MOUSE_USAGE, Integer.toString(0));
        this.jRadioButtonMenuItemNoMouseJoystickEmulation.setSelected(true);
    }

    private void jMenuItemShowLogActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, this.c64.getLogger().dumpAll(), this.commonResources.getString("LogMessages"), 1);
    }

    private void jMenuItemContentsActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(new URI(URL_ONLINE_HELP));
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this, this.commonResources.getString("CouldNotStartBrowser") + " '" + URL_ONLINE_HELP + "'", this.commonResources.getString("CouldNotDisplayOnlineHelp"), 0);
        }
    }

    private void jRadioButtonMenuItemJoystickPort2ActionPerformed(ActionEvent evt) {
        this.c64.setActiveJoystick(1);
        this.settings.setProperty(SETTING_JOYSTICK_PORT, "1");
        this.jRadioButtonMenuItemJoystickPort2.setSelected(true);
    }

    private void jRadioButtonMenuItemJoystickPort1ActionPerformed(ActionEvent evt) {
        this.c64.setActiveJoystick(0);
        this.settings.setProperty(SETTING_JOYSTICK_PORT, "0");
        this.jRadioButtonMenuItemJoystickPort1.setSelected(true);
    }

    private void jMenuItemSizeX1ActionPerformed(ActionEvent evt) {
        this.canvas.setScaling(1);
        this.settings.setProperty(SETTING_WINDOW_SCALING, "1");
        this.pack();
        this.jMenuItemSizeX1.setSelected(true);
    }

    private void jMenuItemSizeX2ActionPerformed(ActionEvent evt) {
        this.canvas.setScaling(2);
        this.settings.setProperty(SETTING_WINDOW_SCALING, "2");
        this.pack();
        this.jMenuItemSizeX2.setSelected(true);
    }

    private void jMenuItemSizeX3ActionPerformed(ActionEvent evt) {
        this.canvas.setScaling(3);
        this.settings.setProperty(SETTING_WINDOW_SCALING, "3");
        this.pack();
        this.jMenuItemSizeX3.setSelected(true);
    }

    private void jMenuItemAboutActionPerformed(ActionEvent evt) {
        String text = this.c64Resources.getString("AboutText1") + VERSION + this.c64Resources.getString("AboutText2") + this.c64Resources.getString("AboutText3") + this.c64Resources.getString("AboutText4");
        text = text.replaceAll("\\n", "<br>");
        text = text.replaceAll("\\#PROJECTPAGE\\#", "\\<a href\\=\\'https://sourceforge.net/projects/jmec64/\\'\\>https://sourceforge.net/projects/jmec64/\\<\\/a\\>");
        text = "<html><body>" + text + "</body></html>";
        JEditorPane messagePane = new JEditorPane("text/html", text);
        messagePane.setBackground(this.getBackground());
        messagePane.setEditable(false);
        messagePane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        Desktop.getDesktop().browse(evt.getURL().toURI());
                    }
                    catch (Throwable t) {
                        System.err.println("Could not browse to page " + evt.getURL());
                    }
                }
            }
        });
        JOptionPane.showMessageDialog(this, messagePane);
    }

    private void jMenuItemSpecialKeyActionPerformed(ActionEvent evt) {
        Object[] specialKeys = new String[]{"Run", "Break", "Commodore", "Pound"};
        Object key = JOptionPane.showInputDialog(this, this.c64Resources.getString("SelectKey"), this.c64Resources.getString("SpecialKeys"), -1, null, specialKeys, null);
        if (null != key) {
            this.c64.getKeyboard().keyTyped(key.toString().toUpperCase());
        }
    }

    private void jMenuItemTypeTextActionPerformed(ActionEvent evt) {
        JOptionPane pane = new JOptionPane(this.c64Resources.getString("TextToEnter"), 3, 2);
        JComboBox combobox = new JComboBox(this.c64.getKeyboard().getTypedTexts());
        combobox.setEditable(true);
        combobox.setSelectedIndex(-1);
        pane.add((Component)combobox, 1);
        JDialog dialog = pane.createDialog(this, this.c64Resources.getString("TypeText"));
        combobox.requestFocusInWindow();
        dialog.setVisible(true);
        Object text = combobox.getSelectedItem();
        if (pane.getValue() instanceof Integer && (Integer)pane.getValue() == 0 && null != text) {
            this.c64.getKeyboard().textTyped(text.toString());
        }
    }

    private void jMenuItemLoadProgramActionPerformed(ActionEvent evt) {
        Vector programs = this.c64.getDrive(this.c64.getActiveDrive()).getFilenames();
        if (programs.isEmpty()) {
            JOptionPane.showMessageDialog(this, this.c64Resources.getString("PleaseAttachImageBefore"), this.c64Resources.getString("NoProgramsToLoad"), 2);
        } else {
            Object program = JOptionPane.showInputDialog(this, this.c64Resources.getString("SelectProgram"), this.c64Resources.getString("LoadProgram"), -1, null, programs.toArray(), programs.elementAt(0));
            if (null != program) {
                if (evt.getActionCommand().indexOf(this.c64Resources.getString("FastLoadProgram")) < 0) {
                    this.c64.loadFile(program.toString());
                } else {
                    try {
                        this.c64.fastLoadFile(program.toString(), -1);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(this, this.c64Resources.getString("CouldNotLoadFile") + ": " + program.toString() + "!\n" + e, this.c64Resources.getString("CouldNotLoadFile"), 2);
                    }
                }
            }
        }
    }

    private void jMenuItemRunActionPerformed(ActionEvent evt) {
        this.runProgram();
    }

    private void jMenuItemResetActionPerformed(ActionEvent evt) {
        this.c64.reset();
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        System.exit(0);
    }

    private void jMenuItemAttachImageActionPerformed(ActionEvent evt) {
        this.selectImage();
    }

    private void jMenuItemDetachImagesActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, this.c64Resources.getString("ReallyDetach")) == 0) {
            this.detachImages();
        }
    }

    private void jMenuItemFastC1541ActionPerformed(ActionEvent evt) {
        for (int i = 0; i < 4; ++i) {
            this.c64.getDrive(i).setEmulationLevel(0);
        }
        this.settings.setProperty(SETTING_DRIVE_MODE, Integer.toString(0));
        this.jMenuItemFastC1541.setSelected(true);
    }

    private void jMenuItemBalancedC1541ActionPerformed(ActionEvent evt) {
        for (int i = 0; i < 4; ++i) {
            this.c64.getDrive(i).setEmulationLevel(50);
        }
        this.settings.setProperty(SETTING_DRIVE_MODE, Integer.toString(50));
        this.jMenuItemBalancedC1541.setSelected(true);
    }

    private void jMenuItemCompatibleC1541ActionPerformed(ActionEvent evt) {
        for (int i = 0; i < 4; ++i) {
            this.c64.getDrive(i).setEmulationLevel(100);
        }
        this.settings.setProperty(SETTING_DRIVE_MODE, Integer.toString(100));
        this.jMenuItemCompatibleC1541.setSelected(true);
    }

    private void jMenuItemFrameSkipAutoActionPerformed(ActionEvent evt) {
        this.c64.setDoAutoAdjustFrameskip(true);
        this.settings.setProperty(SETTING_FRAMESKIP, "0");
        this.jMenuItemFrameSkipAuto.setSelected(true);
    }

    private void jMenuItemFrameSkip1ActionPerformed(ActionEvent evt) {
        this.c64.setDoAutoAdjustFrameskip(false);
        this.c64.getVIC().setFrameSkip(1);
        this.settings.setProperty(SETTING_FRAMESKIP, "1");
        this.jMenuItemFrameSkip1.setSelected(true);
    }

    private void jMenuItemFrameSkip2ActionPerformed(ActionEvent evt) {
        this.c64.setDoAutoAdjustFrameskip(false);
        this.c64.getVIC().setFrameSkip(2);
        this.settings.setProperty(SETTING_FRAMESKIP, "2");
        this.jMenuItemFrameSkip2.setSelected(true);
    }

    private void jMenuItemFrameSkip3ActionPerformed(ActionEvent evt) {
        this.c64.setDoAutoAdjustFrameskip(false);
        this.c64.getVIC().setFrameSkip(3);
        this.settings.setProperty(SETTING_FRAMESKIP, "3");
        this.jMenuItemFrameSkip3.setSelected(true);
    }

    private void jMenuItemFrameSkip4ActionPerformed(ActionEvent evt) {
        this.c64.setDoAutoAdjustFrameskip(false);
        this.c64.getVIC().setFrameSkip(4);
        this.settings.setProperty(SETTING_FRAMESKIP, "4");
        this.jMenuItemFrameSkip4.setSelected(true);
    }

    private void jRadioButtonMenuItemTurboModeAutoActionPerformed(ActionEvent evt) {
        this.c64.setThrottlingEnabled(true);
        this.automaticTurboMode = true;
    }

    private void jRadioButtonMenuItemTurboModeOnActionPerformed(ActionEvent evt) {
        this.c64.setThrottlingEnabled(false);
        this.automaticTurboMode = false;
    }

    private void jRadioButtonMenuItemTurboModeOffActionPerformed(ActionEvent evt) {
        this.c64.setThrottlingEnabled(true);
        this.automaticTurboMode = false;
    }

    private void jMenuItemSuspendActionPerformed(ActionEvent evt) {
        this.suspend();
    }

    private void jMenuItemAutoStartActionPerformed(ActionEvent evt) {
        if (this.selectImage()) {
            this.c64.getKeyboard().textTyped("load \"*\",8,1");
            this.c64.getKeyboard().keyTyped("ENTER");
            this.runProgram();
        }
    }

    private void jMenuItemFastAutoStartActionPerformed(ActionEvent evt) {
        if (this.selectImage()) {
            try {
                this.c64.fastLoadFile("*", -1);
                this.runProgram();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, this.c64Resources.getString("CouldNotLoadFile") + "'*'!\n" + e, this.c64Resources.getString("CouldNotLoadFile"), 2);
            }
        }
    }

    private void jMenuItemSaveSnapshotActionPerformed(ActionEvent evt) {
        this.saveSnapshot();
    }

    private void jCheckBoxMenuItemSelectDriveItemStateChanged(ItemEvent evt) {
        JRadioButtonMenuItem item = (JRadioButtonMenuItem)evt.getItem();
        if (item.isSelected()) {
            this.c64.setActiveDrive(item.getText().charAt(0) - 48);
            boolean hasDisk = this.c64.getDrive(this.c64.getActiveDrive()).getDriveHandler() != null;
            this.jMenuLoadProgram.setEnabled(hasDisk);
        }
        for (int i = 0; i < this.jCheckBoxMenuItemSelectedDrives.length; ++i) {
            this.jCheckBoxMenuItemSelectedDrives[i].setSelected(i == this.c64.getActiveDrive());
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new C64Frame().setVisible(true);
            }
        });
    }

    @Override
    public void update(Object observed, Object arg) {
        if (observed == this.c64.getLogger()) {
            String message = arg.toString();
            if (!message.startsWith("Emulator working at ") || message.indexOf("performance") <= 0) {
                this.jLabelMessages.setText(message);
                if (null != this.statusMessageTimer) {
                    this.statusMessageTimer.cancel();
                }
                this.statusMessageTimer = new Timer();
                this.statusMessageTimer.schedule(new TimerTask(){

                    public void run() {
                        C64Frame.this.jLabelMessages.setText("");
                        C64Frame.this.statusMessageTimer = null;
                    }
                }, 5000L);
            }
        } else if (observed instanceof C1541) {
            if (arg instanceof Integer) {
                this.showDriveIcon((Integer)arg);
            } else if (arg instanceof DriveHandler) {
                try {
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.lastFile));
                    byte[] delta = ((DriveHandler)arg).createDelta(in);
                    if (delta.length > 0) {
                        File deltaFile = EmulatorUtils.saveDeltaFile(this.lastFile.getAbsolutePath(), delta);
                        this.c64.getLogger().info(this.c64Resources.getString("SavedChangesToFile") + "'" + deltaFile + "'.");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.c64.getLogger().warning(this.c64Resources.getString("CouldNotSaveChanges") + "'" + this.lastFile + "'!");
                }
            } else if (arg instanceof String) {
                this.jLabelTrackSector.setText(arg.toString());
                this.startDriveStateTimer();
            }
        } else if (observed == this.c64) {
            int performance = this.c64.getPerformance();
            Color background = performance >= 120 ? Color.CYAN : (performance >= 90 ? Color.GREEN : (performance >= 80 ? Color.YELLOW : Color.RED));
            String performanceText = "   " + performance + "% ";
            this.jLabelPerformance.setBackground(background);
            this.jLabelPerformance.setText(performanceText.substring(performanceText.length() - 6, performanceText.length()));
        }
    }

    private void startDriveStateTimer() {
        if (null != this.driveStateTimer) {
            this.driveStateTimer.cancel();
        }
        this.driveStateTimer = new Timer();
        this.driveInactiveTask = new TimerTask(){

            public void run() {
                C64Frame.this.jLabelTrackSector.setText("");
                C64Frame.this.driveStateTimer = null;
                C64Frame.this.showDriveIcon(null);
            }
        };
        this.driveStateTimer.schedule(this.driveInactiveTask, 1000L);
    }

    protected void showDriveIcon(Integer state) {
        if (null == this.driveStateTimer || !state.equals(this.currentDriveState) || this.driveInactiveTask.scheduledExecutionTime() - new Date().getTime() < 200L) {
            String icon = "/res/swing/LED_" + (C1541.READING == state ? "reading" : (C1541.WRITING == state ? "writing" : "inactive")) + ".gif";
            String tooltip = C1541.READING == state ? this.c64Resources.getString("DriveIsReadingData") : (C1541.WRITING == state ? this.c64Resources.getString("DriveIsWritingData") : this.c64Resources.getString("DriveIsInactive"));
            this.jLabelDrives.setIcon(new ImageIcon(this.getClass().getResource(icon)));
            this.jLabelDrives.setToolTipText(tooltip);
            this.currentDriveState = state;
            this.startDriveStateTimer();
        }
        if (this.automaticTurboMode) {
            if (null != state) {
                if (null != this.driveStateTimer) {
                    this.c64.setThrottlingEnabled(false);
                }
            } else {
                this.c64.setThrottlingEnabled(true);
            }
        }
    }
}

