/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.swing;

import de.joergjahnke.c64.core.C64;
import de.joergjahnke.c64.core.Joystick;
import de.joergjahnke.c64.core.Keyboard;
import de.joergjahnke.c64.core.VIC6569;
import de.joergjahnke.c64.swing.VirtualJoystick;
import de.joergjahnke.common.util.Observer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.JPanel;

public class C64Canvas
extends JPanel
implements Observer,
KeyListener,
MouseListener {
    public static final int MOUSE_NO_USAGE = 0;
    public static final int MOUSE_AS_FIRE_BUTTON = 1;
    public static final int MOUSE_FOR_VIRTUAL_JOYSTICK = 2;
    private static final Hashtable keycodeKeyMap = new Hashtable();
    private static final Hashtable keycodeJoystickMap;
    private BufferedImage screenImage;
    private C64 c64;
    private int sx;
    private int sy;
    private int swidth;
    private int sheight;
    private Dimension preferredSize;
    private final Color borderColor = new Color(0);
    private VirtualJoystick virtualJoystick;
    private int joypadX;
    private int joypadY;
    private int mouseUsage = 1;

    public C64Canvas() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.setFocusable(true);
        try {
            this.virtualJoystick = new VirtualJoystick();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(Dimension size) {
        VIC6569 vic = this.c64.getVIC();
        if (size.getHeight() < (double)vic.getBorderHeight()) {
            size.width = vic.getBorderWidth();
            size.height = vic.getBorderHeight();
        }
        this.preferredSize = size;
        this.virtualJoystick.setWidth(size.width / 5);
        this.virtualJoystick.setHeight(size.width / 5);
        this.joypadX = size.width - this.virtualJoystick.getWidth();
        this.joypadY = size.height - this.virtualJoystick.getHeight();
    }

    public void setScaling(int scaling) {
        VIC6569 vic = this.c64.getVIC();
        Dimension newSize = new Dimension(vic.getBorderWidth() * scaling, vic.getBorderHeight() * scaling);
        this.setPreferredSize(newSize);
        this.setSize(this.getPreferredSize());
        this.swidth = vic.getBorderWidth() * scaling;
        this.sheight = vic.getBorderHeight() * scaling;
        this.sx = 0;
        this.sy = 0;
    }

    public final C64 getC64() {
        return this.c64;
    }

    public void setC64(C64 instance) {
        this.c64 = instance;
        VIC6569 vic = instance.getVIC();
        vic.addObserver(this);
        vic.initScreenMemory();
        this.screenImage = new BufferedImage(vic.getBorderWidth(), vic.getBorderHeight(), 2);
        this.setScaling(1);
    }

    public int getMouseUsage() {
        return this.mouseUsage;
    }

    public void setMouseUsage(int usage) {
        this.mouseUsage = usage;
    }

    public void paint(Graphics g) {
        if (this.c64 != null) {
            VIC6569 vic = this.c64.getVIC();
            g.setColor(new Color(this.borderColor.getRGB()));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.screenImage.setRGB(0, 0, vic.getBorderWidth(), vic.getBorderHeight(), vic.getRGBData(), 0, vic.getBorderWidth());
            g.drawImage(this.screenImage, this.sx, this.sy, this.swidth, this.sheight, this);
        }
        if (this.mouseUsage == 2 && null != this.virtualJoystick && this.c64.isReady()) {
            g.drawImage(this.virtualJoystick.getImage(), this.joypadX, this.joypadY, this.virtualJoystick.getWidth(), this.virtualJoystick.getHeight(), this);
        }
    }

    private Object getKeySelection(KeyEvent event) {
        int keyCode = event.getKeyCode();
        String result = null;
        if (keyCode == 65535 && event.isShiftDown()) {
            result = "SHIFT";
        } else if (keyCode == 67 && event.isControlDown()) {
            result = "BREAK";
        } else if (keyCode == 82 && event.isControlDown()) {
            result = "RUN";
        } else if (event.getModifiers() == 0 && keycodeJoystickMap.containsKey(keyCode)) {
            result = keycodeJoystickMap.get(keyCode);
        } else if (keycodeKeyMap.containsKey(keyCode)) {
            result = keycodeKeyMap.get(keyCode).toString();
        }
        return result;
    }

    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 86 && event.getModifiers() == 2) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = clipboard.getContents(null);
            if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    this.c64.getKeyboard().textTyped((String)contents.getTransferData(DataFlavor.stringFlavor));
                }
                catch (Exception e) {}
            }
        } else {
            Object key = this.getKeySelection(event);
            if (null != key) {
                if (key instanceof String) {
                    this.c64.getKeyboard().keyPressed((String)key);
                } else {
                    Joystick joystick = this.c64.getJoystick(this.c64.getActiveJoystick());
                    int value = (Integer)key;
                    joystick.setDirection(joystick.getDirection() | value & 0xF);
                    if ((value & 0x10) != 0) {
                        joystick.setFiring(true);
                    }
                }
            } else if (event.getKeyChar() != '\uffff' && event.getModifiers() == 0) {
                this.c64.getKeyboard().keyPressed(Character.toString(event.getKeyChar()));
            }
        }
    }

    public void keyReleased(KeyEvent event) {
        Object key = this.getKeySelection(event);
        if (null != key) {
            if (key instanceof String) {
                this.c64.getKeyboard().keyReleased((String)key);
            } else {
                Joystick joystick = this.c64.getJoystick(this.c64.getActiveJoystick());
                int value = (Integer)key;
                joystick.setDirection(joystick.getDirection() & ~(value & 0xF));
                if ((value & 0x10) != 0) {
                    joystick.setFiring(false);
                }
            }
        } else if (event.getKeyChar() != '\uffff' && event.getModifiers() == 0) {
            this.c64.getKeyboard().keyReleased(Character.toString(event.getKeyChar()));
        }
    }

    public void keyTyped(KeyEvent event) {
        if (!(event.getKeyChar() != '\uffff' && event.getModifiers() == 0 || event.isAltDown() || event.isControlDown())) {
            Keyboard keyboard = this.c64.getKeyboard();
            String key = Character.toString(event.getKeyChar());
            if (event.isShiftDown() && keyboard.hasShiftedVariant(key)) {
                keyboard.keyReleased("SHIFT");
                keyboard.textTyped(key);
                keyboard.keyTyped("SHIFT");
            } else {
                keyboard.textTyped(key);
            }
        }
    }

    public final void update(Object observable, Object event) {
        if (observable instanceof VIC6569 && !(event instanceof de.joergjahnke.common.ui.Color)) {
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.grabFocus();
        if (e.getButton() == 1) {
            switch (this.mouseUsage) {
                case 2: {
                    int value = this.virtualJoystick.getValue(e.getX() - this.joypadX, e.getY() - this.joypadY);
                    Joystick joystick = this.c64.getJoystick(this.c64.getActiveJoystick());
                    joystick.setDirection(value & 0xF);
                    joystick.setFiring((value & 0x10) != 0);
                    break;
                }
                case 1: {
                    this.c64.getJoystick(this.c64.getActiveJoystick()).setFiring(true);
                    break;
                }
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            switch (this.mouseUsage) {
                case 2: {
                    Joystick joystick = this.c64.getJoystick(this.c64.getActiveJoystick());
                    joystick.setFiring(false);
                    joystick.setDirection(0);
                    break;
                }
                case 1: {
                    this.c64.getJoystick(this.c64.getActiveJoystick()).setFiring(false);
                    break;
                }
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    static {
        keycodeKeyMap.put(8, "BACKSPACE");
        keycodeKeyMap.put(27, "ARROW_LEFT");
        keycodeKeyMap.put(16, "SHIFT");
        keycodeKeyMap.put(10, "ENTER");
        keycodeKeyMap.put(36, "HOME");
        keycodeKeyMap.put(112, "F1");
        keycodeKeyMap.put(114, "F3");
        keycodeKeyMap.put(116, "F5");
        keycodeKeyMap.put(118, "F7");
        keycodeKeyMap.put(37, "LEFT");
        keycodeKeyMap.put(39, "RIGHT");
        keycodeKeyMap.put(38, "UP");
        keycodeKeyMap.put(40, "DOWN");
        keycodeJoystickMap = new Hashtable();
        keycodeJoystickMap.put(37, 4);
        keycodeJoystickMap.put(39, 8);
        keycodeJoystickMap.put(38, 1);
        keycodeJoystickMap.put(40, 2);
        keycodeJoystickMap.put(123, 16);
    }
}

