/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.extendeddevices;

import de.joergjahnke.c64.core.C64;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class EmulatorUtils {
    public static final String DELTA_FILE_EXTENSION = ".gzd";

    public static File attachImage(C64 c64, int driveNo, String selectedFile) throws IOException {
        boolean applyDelta = selectedFile.endsWith(DELTA_FILE_EXTENSION);
        String filename = applyDelta ? selectedFile.substring(0, selectedFile.length() - 4) : selectedFile;
        File fileToLoad = new File(filename);
        c64.getDrive(driveNo).attachImage(new BufferedInputStream(new FileInputStream(fileToLoad)), fileToLoad.getName());
        if (applyDelta) {
            c64.getDrive(driveNo).getDriveHandler().applyDelta(new BufferedInputStream(new GZIPInputStream(new FileInputStream(new File(filename)))));
            c64.getLogger().info("Applied delta file '" + filename + "'");
        }
        return fileToLoad;
    }

    public static File saveDeltaFile(String lastFile, byte[] delta) throws IOException {
        File deltaFile = new File(lastFile + DELTA_FILE_EXTENSION);
        if (deltaFile.exists()) {
            deltaFile.delete();
        }
        GZIPOutputStream gzout = new GZIPOutputStream(new FileOutputStream(deltaFile));
        BufferedOutputStream out = new BufferedOutputStream(gzout);
        for (int i = 0; i < delta.length; ++i) {
            out.write(delta[i]);
        }
        out.flush();
        gzout.finish();
        return deltaFile;
    }
}

