/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.drive;

import de.joergjahnke.c64.core.C64FileEntry;
import de.joergjahnke.c64.drive.DiskDriveHandler;
import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class D64DriveHandler
extends DiskDriveHandler {
    private boolean[] isAllocated;
    private int[] diskID = new int[2];

    public void mount(byte[] bytes) {
        this.imageType = 2;
        this.bytes = bytes;
        this.currentTrack = 1;
        this.currentSector = 0;
        this.isAllocated = new boolean[D64DriveHandler.calculateTotalSectors(40)];
        this.gotoBlock(18, 0);
        byte[] blockBytes = this.readBlock();
        this.setDiskID(new int[]{bytes[162] & 0xFF, bytes[163] & 0xFF});
        this.label = this.readC64Filename(blockBytes, 144, 16);
        this.freeBlocks = 0;
        int i = 4;
        int track = 1;
        int block = 0;
        while (i < 144) {
            this.freeBlocks += blockBytes[i];
            int ba = blockBytes[i + 1] + blockBytes[i + 2] * 256 + blockBytes[i + 3] * 65536;
            for (int j = 0; j < SECTORS_PER_TRACK[track - 1]; ++j) {
                this.isAllocated[block] = (ba & 1 << j) == 0;
                ++block;
            }
            i += 4;
            ++track;
        }
    }

    public Enumeration directoryElements() {
        return new D64DirectoryEnumeration(false){
            private C64FileEntry nextEntry;
            {
                this.nextEntry = null;
            }

            public Object nextElement() {
                C64FileEntry result = this.nextEntry;
                this.nextEntry = null;
                while (null == result) {
                    byte[] dirEntryBytes = (byte[])super.nextElement();
                    int fileType = dirEntryBytes[2] & 0xFF;
                    if (fileType == 0) continue;
                    result = D64DriveHandler.this.createFileEntry(dirEntryBytes);
                }
                return result;
            }

            public boolean hasMoreElements() {
                try {
                    this.nextEntry = (C64FileEntry)this.nextElement();
                    return true;
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }
        };
    }

    public byte[] readFile(C64FileEntry fileEntry) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(fileEntry.blocks * 256);
        D64FileEnumeration en = new D64FileEnumeration(fileEntry.firstTrack, fileEntry.firstSector);
        while (en.hasMoreElements()) {
            byte[] blockBytes = (byte[])en.nextElement();
            out.write(blockBytes, 2, en.getUsableBytes());
        }
        return out.toByteArray();
    }

    public void writeFile(String filename, byte[] bytes) {
        String filename_ = filename;
        if (filename_.charAt(0) == '@') {
            filename_ = filename_.substring(filename_.startsWith("@:") ? 2 : 1);
            this.deleteFile(filename_);
        }
        if (this.calculateFreeBlocks() * 254 < bytes.length) {
            throw new IllegalStateException("Not enough space on the disk");
        }
        int block = this.getFirstFreeBlock(0);
        BlockIdentifier firstBlockID = this.getBlockIdentifier(block);
        int blocks = 0;
        for (int bytesLeft = bytes.length; bytesLeft > 0; bytesLeft -= 254) {
            this.isAllocated[block] = true;
            --this.freeBlocks;
            int nextBlock = this.getFirstFreeBlock(block);
            BlockIdentifier nextBlockID = this.getBlockIdentifier(nextBlock);
            byte[] blockBytes = new byte[256];
            if (bytesLeft > 254) {
                blockBytes[0] = (byte)nextBlockID.track;
                blockBytes[1] = (byte)nextBlockID.sector;
            } else {
                blockBytes[1] = (byte)(bytesLeft + 2);
            }
            System.arraycopy(bytes, bytes.length - bytesLeft, blockBytes, 2, Math.min(bytesLeft, 254));
            this.gotoBlock(this.getBlockIdentifier((int)block).track, this.getBlockIdentifier((int)block).sector);
            this.writeBlock(blockBytes);
            block = nextBlock;
            ++blocks;
        }
        D64DirectoryEnumeration en = new D64DirectoryEnumeration(true);
        while (en.hasMoreElements()) {
            byte[] dirEntryBytes = (byte[])en.nextElement();
            int fileType = dirEntryBytes[2] & 0xFF;
            if (fileType != 0) continue;
            dirEntryBytes[2] = -126;
            dirEntryBytes[3] = (byte)firstBlockID.track;
            dirEntryBytes[4] = (byte)firstBlockID.sector;
            this.writeC64Filename(dirEntryBytes, 5, 16, filename_.trim());
            for (int i = 21; i < 30; ++i) {
                dirEntryBytes[i] = 0;
            }
            dirEntryBytes[30] = (byte)(blocks % 256);
            dirEntryBytes[31] = (byte)(blocks / 256);
            en.saveElement(dirEntryBytes);
            break;
        }
        this.writeBAM();
    }

    public void deleteFile(String filename) {
        D64DirectoryEnumeration en = new D64DirectoryEnumeration(false);
        while (en.hasMoreElements()) {
            byte[] dirEntryBytes = (byte[])en.nextElement();
            int fileType = dirEntryBytes[2] & 0xFF;
            C64FileEntry fileEntry = this.createFileEntry(dirEntryBytes);
            if (fileType == 0 || !D64DriveHandler.matches(fileEntry, filename.trim(), null)) continue;
            dirEntryBytes[2] = 0;
            en.saveElement(dirEntryBytes);
            D64FileEnumeration en2 = new D64FileEnumeration(fileEntry.firstTrack, fileEntry.firstSector);
            while (en2.hasMoreElements()) {
                this.isAllocated[this.getCurrentBlock()] = false;
                ++this.freeBlocks;
            }
        }
        this.writeBAM();
    }

    public void renameFile(String oldFilename, String newFilename) {
        Vector<String> filenames = new Vector<String>();
        Enumeration en = this.directoryElements();
        while (en.hasMoreElements()) {
            filenames.addElement(((C64FileEntry)en.nextElement()).filename.trim());
        }
        if (filenames.contains(newFilename.trim())) {
            throw new IllegalStateException("File '" + newFilename + "' already exists!");
        }
        en = new D64DirectoryEnumeration(false);
        while (((D64DirectoryEnumeration)en).hasMoreElements()) {
            byte[] dirEntryBytes = (byte[])((D64DirectoryEnumeration)en).nextElement();
            int fileType = dirEntryBytes[2] & 0xFF;
            if (fileType == 0 || !this.readC64Filename(dirEntryBytes, 5, 16).trim().equals(oldFilename.trim())) continue;
            this.writeC64Filename(dirEntryBytes, 5, 16, newFilename);
            ((D64DirectoryEnumeration)en).saveElement(dirEntryBytes);
            break;
        }
    }

    private int getCurrentBlock() {
        return this.getBlockNo(new BlockIdentifier(this.currentTrack, this.currentSector));
    }

    protected byte[] readBlockImpl() {
        byte[] blockBytes = new byte[256];
        System.arraycopy(this.bytes, this.getCurrentBlock() * 256, blockBytes, 0, 256);
        return blockBytes;
    }

    protected void writeBlockImpl(byte[] bytes, int numBytes) {
        if (bytes.length > 256) {
            throw new IllegalArgumentException("Block data exceeds block length of 256 bytes!");
        }
        System.arraycopy(bytes, 0, this.bytes, this.getCurrentBlock() * 256, numBytes);
        this.wasModified = true;
    }

    public void allocateBlock(int block) {
        if (this.isAllocated[block]) {
            int nextFreeBlock = this.getFirstFreeBlock(block);
            String nextFreeBlockText = "0,0";
            if (nextFreeBlock >= 0) {
                BlockIdentifier blockID = this.getBlockIdentifier(nextFreeBlock);
                nextFreeBlockText = Integer.toString(blockID.track) + "," + Integer.toString(blockID.sector);
            }
            throw new IllegalStateException("Block is already allocated! Next free block is: " + nextFreeBlockText);
        }
        this.isAllocated[block] = true;
        this.wasModified = true;
    }

    public void allocateBlock(int track, int sector) {
        this.allocateBlock(this.getBlockNo(new BlockIdentifier(track, sector)));
    }

    public void freeBlock(int block) {
        this.wasModified = this.isAllocated[block];
        this.isAllocated[block] = false;
    }

    public void freeBlock(int track, int sector) {
        this.freeBlock(this.getBlockNo(new BlockIdentifier(track, sector)));
    }

    public int[] getDiskID() {
        return this.diskID;
    }

    protected void setDiskID(int[] diskID) {
        this.diskID = diskID;
    }

    public void format(String label, int id) {
        this.gotoBlock(18, 0);
        byte[] blockBytes = this.readBlock();
        this.label = label;
        this.writeC64Filename(blockBytes, 144, 16, label.trim());
        blockBytes[160] = -96;
        blockBytes[161] = -96;
        blockBytes[162] = (byte)this.getDiskID()[0];
        blockBytes[163] = (byte)this.getDiskID()[1];
        blockBytes[164] = -96;
        blockBytes[165] = 50;
        blockBytes[166] = 65;
        blockBytes[167] = -96;
        this.writeBlock(blockBytes);
        for (int i = 0; i < this.isAllocated.length; ++i) {
            this.isAllocated[i] = false;
        }
        this.isAllocated[this.getBlockNo((BlockIdentifier)(D64DriveHandler)this.new BlockIdentifier((int)18, (int)0))] = true;
        this.isAllocated[this.getBlockNo((BlockIdentifier)(D64DriveHandler)this.new BlockIdentifier((int)18, (int)1))] = true;
        this.writeBAM();
    }

    public void validate() {
        this.writeBAM();
    }

    public static int calculateTotalSectors(int tracks) {
        int result = 0;
        for (int i = 0; i < tracks; ++i) {
            result += SECTORS_PER_TRACK[i];
        }
        return result;
    }

    private int calculateFreeBlocks() {
        int result = 0;
        for (int i = 0; i < this.isAllocated.length; ++i) {
            result += this.isAllocated[i] ? 0 : 1;
        }
        return result;
    }

    private int getFirstFreeBlock(int from) {
        for (int i = from; i < this.isAllocated.length; ++i) {
            if (this.isAllocated[i]) continue;
            return i;
        }
        return -1;
    }

    private int getBlockNo(BlockIdentifier trackSector) {
        int track = trackSector.track;
        int sector = trackSector.sector;
        if (track < 1 || track > 40 || sector < 0 || sector > SECTORS_PER_TRACK[track - 1]) {
            throw new RuntimeException("Illegal combination of track and sector: (" + track + "," + sector + ")");
        }
        int blockNo = sector;
        for (int i = 0; i < track - 1; ++i) {
            blockNo += SECTORS_PER_TRACK[i];
        }
        return blockNo;
    }

    private BlockIdentifier getBlockIdentifier(int block) {
        int block_;
        int track = 0;
        int lastSPT = 0;
        for (block_ = block; block_ >= 0; block_ -= lastSPT) {
            lastSPT = SECTORS_PER_TRACK[track++];
        }
        return new BlockIdentifier(track, block_ + lastSPT);
    }

    private void writeBAM() {
        this.gotoBlock(18, 0);
        byte[] blockBytes = this.readBlock();
        blockBytes[0] = 18;
        blockBytes[1] = 1;
        blockBytes[2] = 65;
        blockBytes[3] = 0;
        int i = 4;
        int track = 1;
        int block = 0;
        while (i < 144) {
            int ba = 0;
            int free = 0;
            for (int j = 0; j < SECTORS_PER_TRACK[track - 1]; ++j) {
                if (!this.isAllocated[block]) {
                    ba |= 1 << j;
                    ++free;
                }
                ++block;
            }
            blockBytes[i] = (byte)free;
            blockBytes[i + 1] = (byte)(ba & 0xFF);
            blockBytes[i + 2] = (byte)(ba >> 8 & 0xFF);
            blockBytes[i + 3] = (byte)(ba >> 16 & 0xFF);
            i += 4;
            ++track;
        }
        this.writeBlock(blockBytes);
    }

    class D64DirectoryEnumeration
    extends D64FileEnumeration {
        private boolean wasLastEntry;
        private byte[] blockBytes;
        private int entryStart;
        private final boolean append;

        public D64DirectoryEnumeration(boolean append) {
            super(18, 1);
            this.wasLastEntry = false;
            this.blockBytes = null;
            this.entryStart = 256;
            this.append = append;
        }

        public void saveElement(byte[] dirEntryBytes) {
            System.arraycopy(dirEntryBytes, 2, this.blockBytes, this.entryStart - 32 + 2, 30);
            D64DriveHandler.this.writeBlock(this.blockBytes);
        }

        public boolean hasMoreElements() {
            return !this.wasLastEntry;
        }

        public Object nextElement() {
            if (this.entryStart >= 256) {
                if (!super.hasMoreElements()) {
                    if (!this.append) {
                        throw new NoSuchElementException("Tried to access past end of directory");
                    }
                    int firstFreeBlock = D64DriveHandler.this.getFirstFreeBlock(D64DriveHandler.this.getBlockNo(new BlockIdentifier(18, 1)));
                    BlockIdentifier blockID = D64DriveHandler.this.getBlockIdentifier(firstFreeBlock);
                    this.blockBytes[0] = (byte)blockID.track;
                    this.blockBytes[1] = (byte)blockID.sector;
                    D64DriveHandler.this.writeBlock(this.blockBytes);
                    D64DriveHandler.this.gotoBlock(blockID.track, blockID.sector);
                    this.blockBytes = new byte[256];
                } else {
                    this.blockBytes = (byte[])super.nextElement();
                }
                this.entryStart = 0;
            }
            byte[] dirEntryBytes = new byte[32];
            System.arraycopy(this.blockBytes, this.entryStart, dirEntryBytes, 0, 32);
            this.entryStart += 32;
            this.wasLastEntry = !super.hasMoreElements() && this.entryStart >= 256 && !this.append;
            return dirEntryBytes;
        }
    }

    class D64FileEnumeration
    implements Enumeration {
        private boolean wasLastSector = false;
        private int nextTrack;
        private int nextSector;

        public D64FileEnumeration(int firstTrack, int firstSector) {
            this.nextTrack = firstTrack;
            this.nextSector = firstSector;
        }

        public int getUsableBytes() {
            return this.nextTrack == 0 ? this.nextSector - 1 : 254;
        }

        public boolean hasMoreElements() {
            return !this.wasLastSector;
        }

        public Object nextElement() {
            D64DriveHandler.this.gotoBlock(this.nextTrack, this.nextSector);
            byte[] blockBytes = D64DriveHandler.this.readBlock();
            this.nextTrack = blockBytes[0] & 0xFF;
            this.nextSector = blockBytes[1] & 0xFF;
            this.wasLastSector = this.nextTrack == 0;
            return blockBytes;
        }
    }

    class BlockIdentifier {
        public int track;
        public int sector;

        public BlockIdentifier(int track, int sector) {
            this.track = track;
            this.sector = sector;
        }
    }
}

