/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.io.SerializationUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class Keyboard
implements Serializable {
    private static final int MAX_HISTORY = 100;
    private static final Hashtable keyMap = new Hashtable();
    private int[] rowMatrix = new int[8];
    private int[] columnMatrix = new int[8];
    private final Vector typedKeysBuffer = new Vector();
    private boolean isTyping = false;
    private int typeDelay = 0;
    private final Vector typedTexts = new Vector();
    private final StringBuffer currentText = new StringBuffer();
    private String lastKey = null;
    private boolean hasCIARead = false;
    private boolean isShiftPressed = false;

    public Keyboard() {
        this.reset();
        if (keyMap.isEmpty()) {
            this.initializeKeyMap();
        }
    }

    public void reset() {
        for (int i = 0; i < 8; ++i) {
            this.rowMatrix[i] = 255;
            this.columnMatrix[i] = 255;
        }
        this.isTyping = false;
        this.isShiftPressed = false;
        this.typedKeysBuffer.removeAllElements();
        this.currentText.delete(0, this.currentText.length());
    }

    private void initializeKeyMap() {
        keyMap.put("a", new KeyTableEntry(1, 2, false));
        keyMap.put("A", new KeyTableEntry(1, 2, false));
        keyMap.put("b", new KeyTableEntry(3, 4, false));
        keyMap.put("B", new KeyTableEntry(3, 4, false));
        keyMap.put("c", new KeyTableEntry(2, 4, false));
        keyMap.put("C", new KeyTableEntry(2, 4, false));
        keyMap.put("d", new KeyTableEntry(2, 2, false));
        keyMap.put("D", new KeyTableEntry(2, 2, false));
        keyMap.put("e", new KeyTableEntry(1, 6, false));
        keyMap.put("E", new KeyTableEntry(1, 6, false));
        keyMap.put("f", new KeyTableEntry(2, 5, false));
        keyMap.put("F", new KeyTableEntry(2, 5, false));
        keyMap.put("g", new KeyTableEntry(3, 2, false));
        keyMap.put("G", new KeyTableEntry(3, 2, false));
        keyMap.put("h", new KeyTableEntry(3, 5, false));
        keyMap.put("H", new KeyTableEntry(3, 5, false));
        keyMap.put("i", new KeyTableEntry(4, 1, false));
        keyMap.put("I", new KeyTableEntry(4, 1, false));
        keyMap.put("j", new KeyTableEntry(4, 2, false));
        keyMap.put("J", new KeyTableEntry(4, 2, false));
        keyMap.put("k", new KeyTableEntry(4, 5, false));
        keyMap.put("K", new KeyTableEntry(4, 5, false));
        keyMap.put("l", new KeyTableEntry(5, 2, false));
        keyMap.put("L", new KeyTableEntry(5, 2, false));
        keyMap.put("m", new KeyTableEntry(4, 4, false));
        keyMap.put("M", new KeyTableEntry(4, 4, false));
        keyMap.put("n", new KeyTableEntry(4, 7, false));
        keyMap.put("N", new KeyTableEntry(4, 7, false));
        keyMap.put("o", new KeyTableEntry(4, 6, false));
        keyMap.put("O", new KeyTableEntry(4, 6, false));
        keyMap.put("p", new KeyTableEntry(5, 1, false));
        keyMap.put("P", new KeyTableEntry(5, 1, false));
        keyMap.put("q", new KeyTableEntry(7, 6, false));
        keyMap.put("Q", new KeyTableEntry(7, 6, false));
        keyMap.put("r", new KeyTableEntry(2, 1, false));
        keyMap.put("R", new KeyTableEntry(2, 1, false));
        keyMap.put("s", new KeyTableEntry(1, 5, false));
        keyMap.put("S", new KeyTableEntry(1, 5, false));
        keyMap.put("t", new KeyTableEntry(2, 6, false));
        keyMap.put("T", new KeyTableEntry(2, 6, false));
        keyMap.put("u", new KeyTableEntry(3, 6, false));
        keyMap.put("U", new KeyTableEntry(3, 6, false));
        keyMap.put("v", new KeyTableEntry(3, 7, false));
        keyMap.put("V", new KeyTableEntry(3, 7, false));
        keyMap.put("w", new KeyTableEntry(1, 1, false));
        keyMap.put("W", new KeyTableEntry(1, 1, false));
        keyMap.put("x", new KeyTableEntry(2, 7, false));
        keyMap.put("X", new KeyTableEntry(2, 7, false));
        keyMap.put("y", new KeyTableEntry(3, 1, false));
        keyMap.put("Y", new KeyTableEntry(3, 1, false));
        keyMap.put("z", new KeyTableEntry(1, 4, false));
        keyMap.put("Z", new KeyTableEntry(1, 4, false));
        keyMap.put("0", new KeyTableEntry(4, 3, false));
        keyMap.put("1", new KeyTableEntry(7, 0, false));
        keyMap.put("2", new KeyTableEntry(7, 3, false));
        keyMap.put("3", new KeyTableEntry(1, 0, false));
        keyMap.put("4", new KeyTableEntry(1, 3, false));
        keyMap.put("5", new KeyTableEntry(2, 0, false));
        keyMap.put("6", new KeyTableEntry(2, 3, false));
        keyMap.put("7", new KeyTableEntry(3, 0, false));
        keyMap.put("8", new KeyTableEntry(3, 3, false));
        keyMap.put("9", new KeyTableEntry(4, 0, false));
        keyMap.put(" ", new KeyTableEntry(7, 4, false));
        keyMap.put("SPACE", new KeyTableEntry(7, 4, false));
        keyMap.put(",", new KeyTableEntry(5, 7, false));
        keyMap.put("<", new KeyTableEntry(5, 7, true));
        keyMap.put(".", new KeyTableEntry(5, 4, false));
        keyMap.put(">", new KeyTableEntry(5, 4, true));
        keyMap.put("=", new KeyTableEntry(6, 5, false));
        keyMap.put(":", new KeyTableEntry(5, 5, false));
        keyMap.put(";", new KeyTableEntry(6, 2, false));
        keyMap.put("+", new KeyTableEntry(5, 0, false));
        keyMap.put("-", new KeyTableEntry(5, 3, false));
        keyMap.put("*", new KeyTableEntry(6, 1, false));
        keyMap.put("ASTERISK", new KeyTableEntry(6, 1, false));
        keyMap.put("/", new KeyTableEntry(6, 7, false));
        keyMap.put("@", new KeyTableEntry(5, 6, false));
        keyMap.put("#", new KeyTableEntry(1, 0, true));
        keyMap.put("ARROW_LEFT", new KeyTableEntry(7, 1, false));
        keyMap.put("ESCAPE", new KeyTableEntry(7, 1, false));
        keyMap.put("ARROW_UP", new KeyTableEntry(6, 6, false));
        keyMap.put("HOME", new KeyTableEntry(6, 3, false));
        keyMap.put("RUN", new KeyTableEntry(7, 7, false));
        keyMap.put("DELETE", new KeyTableEntry(0, 0, false));
        keyMap.put("BACKSPACE", new KeyTableEntry(0, 0, false));
        keyMap.put("BACK_SPACE", new KeyTableEntry(0, 0, false));
        keyMap.put("POUND", new KeyTableEntry(6, 0, false));
        keyMap.put("SHIFT", new KeyTableEntry(1, 7, false));
        keyMap.put("AUTOSHIFT", new KeyTableEntry(1, 7, false));
        keyMap.put("CAPS_LOCK", new KeyTableEntry(6, 4, false));
        keyMap.put("COMMODORE", new KeyTableEntry(7, 5, false));
        keyMap.put("BREAK", new KeyTableEntry(7, 7, false));
        keyMap.put("\r", new KeyTableEntry(0, 1, false));
        keyMap.put("CONTROL", new KeyTableEntry(7, 2, false));
        keyMap.put("ENTER", new KeyTableEntry(0, 1, false));
        keyMap.put("DOWN", new KeyTableEntry(0, 7, false));
        keyMap.put("UP", new KeyTableEntry(0, 7, true));
        keyMap.put("RIGHT", new KeyTableEntry(0, 2, false));
        keyMap.put("LEFT", new KeyTableEntry(0, 2, true));
        keyMap.put("CURSOR DOWN", new KeyTableEntry(0, 7, false));
        keyMap.put("CURSOR UP", new KeyTableEntry(0, 7, true));
        keyMap.put("CURSOR RIGHT", new KeyTableEntry(0, 2, false));
        keyMap.put("CURSOR LEFT", new KeyTableEntry(0, 2, true));
        keyMap.put("F1", new KeyTableEntry(0, 4, false));
        keyMap.put("F3", new KeyTableEntry(0, 5, false));
        keyMap.put("F5", new KeyTableEntry(0, 6, false));
        keyMap.put("F7", new KeyTableEntry(0, 3, false));
        keyMap.put("!", new KeyTableEntry(7, 0, true));
        keyMap.put("\"", new KeyTableEntry(7, 3, true));
        keyMap.put("\u00a7", new KeyTableEntry(1, 0, true));
        keyMap.put("$", new KeyTableEntry(1, 3, true));
        keyMap.put("%", new KeyTableEntry(2, 0, true));
        keyMap.put("&", new KeyTableEntry(2, 3, true));
        keyMap.put("'", new KeyTableEntry(3, 0, true));
        keyMap.put("(", new KeyTableEntry(3, 3, true));
        keyMap.put(")", new KeyTableEntry(4, 0, true));
        keyMap.put("?", new KeyTableEntry(6, 7, true));
        keyMap.put("[", new KeyTableEntry(5, 5, true));
        keyMap.put("]", new KeyTableEntry(6, 2, true));
    }

    public void keyPressed(String key) {
        KeyTableEntry ktEntry = (KeyTableEntry)keyMap.get(key);
        if (ktEntry != null) {
            int row = ktEntry.row;
            int col = ktEntry.col;
            int n = row;
            this.rowMatrix[n] = this.rowMatrix[n] & 255 - (1 << col);
            int n2 = col;
            this.columnMatrix[n2] = this.columnMatrix[n2] & 255 - (1 << row);
            if (ktEntry.autoshift && !this.isShiftPressed) {
                this.keyPressed("AUTOSHIFT");
            }
            this.lastKey = key;
            this.hasCIARead = false;
            if ("SHIFT".equals(key)) {
                this.isShiftPressed = true;
            }
        }
    }

    public void keyReleased(String key) {
        KeyTableEntry ktEntry = (KeyTableEntry)keyMap.get(key);
        if (ktEntry != null) {
            if (this.hasCIARead) {
                int row = ktEntry.row;
                int col = ktEntry.col;
                int n = row;
                this.rowMatrix[n] = this.rowMatrix[n] | 1 << col;
                int n2 = col;
                this.columnMatrix[n2] = this.columnMatrix[n2] | 1 << row;
                if (ktEntry.autoshift && !this.isShiftPressed) {
                    this.keyReleased("AUTOSHIFT");
                }
                this.hasCIARead = false;
                if ("SHIFT".equals(key)) {
                    this.isShiftPressed = false;
                }
                if (key.equals(this.lastKey)) {
                    if ("ENTER".equals(key) || "\n".equals(key) || "\r".equals(key)) {
                        if (this.currentText.length() > 0) {
                            this.typedTexts.removeElement(this.currentText.toString());
                            this.typedTexts.insertElementAt(this.currentText.toString(), 0);
                            if (this.typedTexts.size() > 100) {
                                this.typedTexts.removeElementAt(100);
                            }
                            this.currentText.delete(0, this.currentText.length());
                        }
                    } else if ("BACKSPACE".equals(key) || "DELETE".equals(key)) {
                        if (this.currentText.length() > 0) {
                            this.currentText.deleteCharAt(this.currentText.length() - 1);
                        }
                    } else if (key.length() > 1) {
                        if (!"SHIFT".equals(key) && !"AUTOSHIFT".equals(key)) {
                            this.currentText.delete(0, this.currentText.length());
                        }
                    } else {
                        this.currentText.append(key);
                    }
                }
            } else {
                this.keyTyped(key);
            }
        }
    }

    public void keyTyped(String key) {
        this.typedKeysBuffer.addElement(key);
    }

    public void textTyped(String text) {
        for (int i = 0; i < text.length(); ++i) {
            this.keyTyped(new Character(text.charAt(i)).toString());
        }
    }

    public Vector getTypedTexts() {
        return this.typedTexts;
    }

    private short getCIARegisterAdjustment(int testRegisterValue, int[] matrix) {
        int result = 255;
        int mask = 1;
        for (int i = 0; i < 8; ++i) {
            if ((testRegisterValue & mask) == 0) {
                result &= matrix[i];
            }
            mask <<= 1;
        }
        this.hasCIARead = true;
        return (short)result;
    }

    public short getCIAPRAAdjustment(int testRegisterValue) {
        return this.getCIARegisterAdjustment(testRegisterValue, this.columnMatrix);
    }

    public short getCIAPRBAdjustment(int testRegisterValue) {
        short result = this.getCIARegisterAdjustment(testRegisterValue, this.rowMatrix);
        if (this.typeDelay > 0) {
            --this.typeDelay;
        } else if (this.isTyping) {
            this.keyReleased((String)this.typedKeysBuffer.elementAt(0));
            this.typedKeysBuffer.removeElementAt(0);
            this.isTyping = false;
            this.typeDelay = 5;
        } else if (!this.typedKeysBuffer.isEmpty()) {
            this.keyPressed((String)this.typedKeysBuffer.elementAt(0));
            this.isTyping = true;
            this.typeDelay = 20;
        }
        return result;
    }

    public boolean hasShiftedVariant(String key) {
        KeyTableEntry entry = (KeyTableEntry)keyMap.get(key);
        return entry != null && !entry.autoshift && keyMap.contains(new KeyTableEntry(entry.row, entry.col, true));
    }

    public void serialize(DataOutputStream out) throws IOException {
        SerializationUtils.serialize(out, this.rowMatrix);
        SerializationUtils.serialize(out, this.columnMatrix);
        out.writeInt(this.typedKeysBuffer.size());
        for (int i = 0; i < this.typedKeysBuffer.size(); ++i) {
            out.writeUTF(this.typedKeysBuffer.elementAt(i).toString());
        }
        out.writeBoolean(this.isTyping);
        out.writeInt(this.typeDelay);
        out.writeUTF(this.currentText.toString());
        out.writeBoolean(this.lastKey != null);
        if (this.lastKey != null) {
            out.writeUTF(this.lastKey);
        }
        out.writeBoolean(this.hasCIARead);
    }

    public void deserialize(DataInputStream in) throws IOException {
        SerializationUtils.deserialize(in, this.rowMatrix);
        SerializationUtils.deserialize(in, this.columnMatrix);
        this.typedKeysBuffer.removeAllElements();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.typedKeysBuffer.addElement(in.readUTF());
        }
        this.isTyping = in.readBoolean();
        this.typeDelay = in.readInt();
        if (this.currentText.length() > 0) {
            this.currentText.delete(0, this.currentText.length() - 1);
        }
        this.currentText.append(in.readUTF());
        if (in.readBoolean()) {
            this.lastKey = in.readUTF();
        }
        this.hasCIARead = in.readBoolean();
    }

    class KeyTableEntry {
        public final int row;
        public final int col;
        public final int code;
        public final boolean autoshift;

        public KeyTableEntry(int row, int col, boolean autoshift) {
            this.row = row;
            this.col = col;
            this.code = (row << 3) + col;
            this.autoshift = autoshift;
        }

        public int hashCode() {
            return this.code | (this.autoshift ? 64 : 0);
        }

        public boolean equals(Object other) {
            return other instanceof KeyTableEntry && other.hashCode() == this.hashCode();
        }

        public final String toString() {
            return this.getClass().getName() + "( " + this.row + ", " + this.col + ", " + this.autoshift + " )";
        }
    }
}

