/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.C1541;
import de.joergjahnke.c64.core.C64CPU6510;
import de.joergjahnke.c64.core.CIA6526;
import de.joergjahnke.c64.core.CIA6526_1;
import de.joergjahnke.c64.core.CIA6526_2;
import de.joergjahnke.c64.core.CPU6502;
import de.joergjahnke.c64.core.EmulatedDevice;
import de.joergjahnke.c64.core.IECBus;
import de.joergjahnke.c64.core.Joystick;
import de.joergjahnke.c64.core.Keyboard;
import de.joergjahnke.c64.core.SID6581;
import de.joergjahnke.c64.core.VIC6569;
import de.joergjahnke.common.emulation.PerformanceMeter;
import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.io.SerializationUtils;
import de.joergjahnke.common.util.DefaultLogger;
import de.joergjahnke.common.util.Observer;
import de.joergjahnke.common.vmabstraction.ResourceLoader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class C64
extends EmulatedDevice
implements Observer,
Serializable {
    private static final int FRAMESKIP_MAX = 4;
    public static final int ORIGINAL_SPEED = 985248;
    private static final int SID_SAMPLE_SIZE = 8000;
    public static final int MAX_NUM_DRIVES = 4;
    private C1541[] drives;
    private int activeDrive = 0;
    private CIA6526[] cias;
    private IECBus iecBus;
    private VIC6569 vic;
    private SID6581 sid;
    private Keyboard keyboard;
    private Joystick[] joysticks;
    private int activeJoystick = 0;
    private int frameSkipMin = 1;
    private boolean doAutoAdjustFrameskip = true;
    private PerformanceMeter performanceMeter;
    private final int numDrives;

    public C64(ResourceLoader resourceLoader) {
        this(resourceLoader, 4);
    }

    public C64(ResourceLoader resourceLoader, int numDrives) {
        super("C64", resourceLoader);
        if (numDrives < 1 && numDrives > 4) {
            throw new IllegalArgumentException("Number of C64 drives must be between 1 and 4!");
        }
        this.numDrives = numDrives;
        this.setLogger(new DefaultLogger(100));
        this.addObserver(this);
        this.cias = new CIA6526[2];
        this.cias[0] = new CIA6526_1(this);
        this.cias[1] = new CIA6526_2(this);
        this.setVIC(new VIC6569(this));
        this.iecBus = new IECBus(this);
        this.sid = new SID6581(this, 8000);
        this.keyboard = new Keyboard();
        this.joysticks = new Joystick[2];
        this.joysticks[0] = new Joystick();
        this.joysticks[1] = new Joystick();
        this.drives = new C1541[this.getDriveCount()];
        for (int i = 0; i < this.getDriveCount(); ++i) {
            this.drives[i] = new C1541(i, resourceLoader, this.iecBus);
            this.drives[i].setLogger(this.getLogger());
        }
        this.performanceMeter = new PerformanceMeter(this.cpu, 985248);
        this.performanceMeter.addObserver(this);
        this.getLogger().info(this.getName() + " initialized");
    }

    public final VIC6569 getVIC() {
        return this.vic;
    }

    public final void setVIC(VIC6569 vic) {
        if (this.isRunning() && !this.isPaused()) {
            throw new IllegalStateException("C64 must be paused while setting a new VIC!");
        }
        if (null != this.vic) {
            this.vic.deleteObserver(this);
            this.cias[1].deleteObserver(this.vic);
        }
        this.vic = vic;
        this.vic.addObserver(this);
        ((C64CPU6510)this.cpu).setVIC(vic);
        this.cias[1].addObserver(vic);
    }

    public final IECBus getIECBus() {
        return this.iecBus;
    }

    public final CIA6526 getCIA(int n) {
        return this.cias[n];
    }

    public final Keyboard getKeyboard() {
        return this.keyboard;
    }

    public final SID6581 getSID() {
        return this.sid;
    }

    public final C1541 getDrive(int n) {
        return this.drives[n];
    }

    public int getActiveDrive() {
        return this.activeDrive;
    }

    public void setActiveDrive(int n) {
        this.activeDrive = n;
    }

    public final int getDriveCount() {
        return this.numDrives;
    }

    public final Joystick getJoystick(int n) {
        return this.joysticks[n];
    }

    public int getActiveJoystick() {
        return this.activeJoystick;
    }

    public void setActiveJoystick(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("Cannot activate joystick ID " + n + "!");
        }
        this.activeJoystick = n;
    }

    public final boolean isReady() {
        return ((CIA6526_1)this.cias[0]).getPRBReads() >= 20;
    }

    public final int getPerformance() {
        return this.performanceMeter.getLastPerformance();
    }

    public final int getThrottlePercentage() {
        return this.performanceMeter.getThrottlePercentage();
    }

    public void setThrottlingEnabled(boolean doThrottling) {
        this.performanceMeter.setDoThrottling(doThrottling);
        if (doThrottling) {
            this.performanceMeter.resetThrottleMeasurement(this.cpu.getCycles());
        }
    }

    public boolean doAutoAdjustFrameskip() {
        return this.doAutoAdjustFrameskip;
    }

    public void setDoAutoAdjustFrameskip(boolean doAutoAdjustFrameskip) {
        this.doAutoAdjustFrameskip = doAutoAdjustFrameskip;
    }

    public void stop() {
        int i;
        for (i = 0; i < this.getDriveCount(); ++i) {
            this.drives[i].pause();
        }
        super.stop();
        for (i = 0; i < this.getDriveCount(); ++i) {
            this.drives[i].stop();
            this.drives[i].detachImage();
        }
    }

    public void loadFile(String filename) {
        this.getKeyboard().textTyped("Load \"" + filename + "\"," + (this.getActiveDrive() + 8) + ",1");
        this.getKeyboard().keyTyped("ENTER");
    }

    public void fastLoadFile(String filename, int address) throws IOException {
        int endAddress = this.cpu.copyBytesToMemory(this.getDrive(this.activeDrive).readFile(filename, "PRG"), address);
        this.cpu.writeByte(174, (byte)(endAddress & 0xFF));
        this.cpu.writeByte(175, (byte)(endAddress >> 8 & 0xFF));
        if (endAddress > 40704) {
            endAddress = 40704;
        }
        this.cpu.writeByte(45, (byte)(endAddress & 0xFF));
        this.cpu.writeByte(47, (byte)(endAddress & 0xFF));
        this.cpu.writeByte(49, (byte)(endAddress & 0xFF));
        this.cpu.writeByte(46, (byte)((endAddress & 0xFF00) >> 8));
        this.cpu.writeByte(48, (byte)((endAddress & 0xFF00) >> 8));
        this.cpu.writeByte(50, (byte)((endAddress & 0xFF00) >> 8));
    }

    public void update(Object observed, Object arg) {
        if (observed == this) {
            if (this.doAutoAdjustFrameskip()) {
                int performance = this.getPerformance();
                int frameskip = this.getVIC().getFrameSkip();
                if (this.getThrottlePercentage() >= 50 && this.frameSkipMin > 1) {
                    --this.frameSkipMin;
                }
                if (performance > 95 && frameskip > this.frameSkipMin) {
                    this.getVIC().setFrameSkip(frameskip - 1);
                } else if (performance < 90 && frameskip < 4) {
                    this.getVIC().setFrameSkip(frameskip + 1);
                    if (this.frameSkipMin <= 4) {
                        ++this.frameSkipMin;
                    }
                }
            }
        } else if (observed == this.vic) {
            this.performanceMeter.measure(this.cpu.getCycles());
        } else if (observed == this.performanceMeter) {
            this.getLogger().info(arg.toString());
            this.setChanged(true);
            this.notifyObservers();
        }
    }

    public void run() {
        super.run();
        CPU6502 cpu_ = this.cpu;
        C1541[] drives_ = this.drives;
        SID6581 sid_ = this.sid;
        CIA6526 cia0 = this.cias[0];
        CIA6526 cia1 = this.cias[1];
        long nextIOUpdate = 0L;
        long nextDriveUpdate = 0L;
        while (this.isRunning) {
            try {
                VIC6569 vic_ = this.vic;
                while (!this.isPaused) {
                    cpu_.emulateNextInstruction();
                    long cycles = cpu_.getCycles();
                    vic_.update(cycles);
                    if (cycles >= nextDriveUpdate) {
                        nextDriveUpdate = cycles + 1000L;
                        int to = this.getDriveCount();
                        for (int i = 0; i < to; ++i) {
                            if (cycles >= drives_[i].getNextUpdate()) {
                                drives_[i].update(cycles);
                            }
                            nextDriveUpdate = Math.min(nextDriveUpdate, this.drives[i].getNextUpdate());
                        }
                    }
                    if (cycles < nextIOUpdate) continue;
                    if (cycles >= sid_.getNextUpdate()) {
                        sid_.update(cycles);
                    }
                    if (cycles >= cia0.getNextUpdate()) {
                        cia0.update(cycles);
                    }
                    if (cycles >= cia1.getNextUpdate()) {
                        cia1.update(cycles);
                    }
                    nextIOUpdate = Math.min(Math.min(sid_.getNextUpdate(), cia0.getNextUpdate()), cia1.getNextUpdate());
                }
                if (!this.isPaused) continue;
                Thread.sleep(100L);
            }
            catch (Exception e) {
                if (null != this.getLogger()) {
                    this.getLogger().error("Exception before $" + Integer.toHexString(this.cpu.getPC()) + ", exception: " + e);
                    Vector stack = this.cpu.getStackTrace();
                    StringBuffer st = new StringBuffer("Call-stack:");
                    for (int i = 0; i < stack.size(); ++i) {
                        st.append(" $");
                        st.append(Integer.toHexString((Integer)stack.elementAt(i)));
                    }
                    this.getLogger().error(st.toString());
                }
                e.printStackTrace();
                this.setChanged(true);
                this.notifyObservers(e);
            }
        }
    }

    protected CPU6502 createCPU() {
        return new C64CPU6510(this);
    }

    protected void resetIOChips() {
        this.vic.reset();
        this.sid.reset();
        this.getKeyboard().reset();
        this.iecBus.reset();
        this.cpu.reset();
        this.cias[0].reset();
        this.cias[1].reset();
    }

    public void serialize(DataOutputStream out) throws IOException {
        SerializationUtils.serialize(out, this.cias);
        SerializationUtils.setMarker(out);
        this.keyboard.serialize(out);
        SerializationUtils.setMarker(out);
        SerializationUtils.serialize(out, this.joysticks);
        SerializationUtils.setMarker(out);
        this.iecBus.serialize(out);
        SerializationUtils.setMarker(out);
        this.sid.serialize(out);
        SerializationUtils.setMarker(out);
        this.vic.serialize(out);
        SerializationUtils.setMarker(out);
        this.cpu.serialize(out);
        SerializationUtils.setMarker(out);
        SerializationUtils.serialize(out, this.drives);
        SerializationUtils.setMarker(out);
    }

    public void deserialize(DataInputStream in) throws IOException {
        SerializationUtils.deserialize(in, this.cias);
        SerializationUtils.verifyMarker(in);
        this.keyboard.deserialize(in);
        SerializationUtils.verifyMarker(in);
        SerializationUtils.deserialize(in, this.joysticks);
        SerializationUtils.verifyMarker(in);
        this.iecBus.deserialize(in);
        SerializationUtils.verifyMarker(in);
        this.sid.deserialize(in);
        SerializationUtils.verifyMarker(in);
        this.vic.deserialize(in);
        SerializationUtils.verifyMarker(in);
        this.cpu.deserialize(in);
        SerializationUtils.verifyMarker(in);
        SerializationUtils.deserialize(in, this.drives);
        SerializationUtils.verifyMarker(in);
        this.performanceMeter.setupNextMeasurement(this.cpu.getCycles());
    }
}

