/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.C1541CPU6502;
import de.joergjahnke.c64.core.C64FileEntry;
import de.joergjahnke.c64.core.CPU6502;
import de.joergjahnke.c64.core.EmulatedDevice;
import de.joergjahnke.c64.core.EmulatedIECBusDevice;
import de.joergjahnke.c64.core.IECBus;
import de.joergjahnke.c64.core.VIA6522;
import de.joergjahnke.c64.core.VIA6522_BC;
import de.joergjahnke.c64.core.VIA6522_DC;
import de.joergjahnke.c64.drive.D64DriveHandler;
import de.joergjahnke.c64.drive.DiskDriveHandler;
import de.joergjahnke.c64.drive.DriveChannel;
import de.joergjahnke.c64.drive.DriveCommandChannel;
import de.joergjahnke.c64.drive.DriveHandler;
import de.joergjahnke.c64.drive.FileReadDriveChannel;
import de.joergjahnke.c64.drive.FileWriteDriveChannel;
import de.joergjahnke.c64.drive.MultiPurposeDriveChannel;
import de.joergjahnke.c64.drive.P00DriveHandler;
import de.joergjahnke.c64.drive.PRGDriveHandler;
import de.joergjahnke.c64.drive.T64DriveHandler;
import de.joergjahnke.c64.drive.Tape2DiskAdapterDriveHandler;
import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.io.SerializationUtils;
import de.joergjahnke.common.util.Observer;
import de.joergjahnke.common.vmabstraction.ResourceLoader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class C1541
extends EmulatedIECBusDevice
implements Observer,
Serializable {
    public static final boolean DEBUG = false;
    public static final Vector SUPPORTED_EXTENSIONS = new Vector();
    public static final Integer READING;
    public static final Integer WRITING;
    public static final Integer DISK_MOUNTED;
    private static final long DEACTIVATION_CYCLES = 1000000L;
    public static final int FAST_EMULATION = 0;
    public static final int BALANCED_EMULATION = 50;
    public static final int COMPATIBLE_EMULATION = 100;
    private final Hashtable driveHandlers = new Hashtable();
    private final int id;
    private final VIA6522[] vias;
    private DiskDriveHandler driveHandler;
    private boolean isEmulateDC = false;
    private boolean isEmulateDiskRotation = false;
    private boolean isEmulateDriveCPU = true;
    protected final IECBus iecBus;
    private C1541Impl impl = null;
    private int emulationLevel = -1;

    public C1541(int id, ResourceLoader resourceLoader, IECBus iecBus) {
        super("C1541 #" + (id + 8), resourceLoader);
        if (id < 0 || id > 3) {
            throw new IllegalArgumentException("C1541 drive ID must be 0-3!");
        }
        this.id = id;
        this.iecBus = iecBus;
        ((C1541CPU6502)this.cpu).patchROMs();
        this.vias = new VIA6522[2];
        this.vias[0] = new VIA6522_BC(this, iecBus);
        this.vias[1] = new VIA6522_DC(this);
        this.driveHandlers.put("d64", new D64DriveHandler());
        this.driveHandlers.put("t64", new Tape2DiskAdapterDriveHandler(new T64DriveHandler()));
        this.driveHandlers.put("prg", new Tape2DiskAdapterDriveHandler(new PRGDriveHandler()));
        this.driveHandlers.put("p00", new Tape2DiskAdapterDriveHandler(new P00DriveHandler()));
        Enumeration en = this.driveHandlers.elements();
        while (en.hasMoreElements()) {
            ((DriveHandler)en.nextElement()).addObserver(this);
        }
        this.setEmulationLevel(50);
    }

    protected void finalize() throws Throwable {
        this.detachImage();
    }

    public boolean isEmulateDiskController() {
        return this.isEmulateDC;
    }

    public boolean isEmulateDiskRotation() {
        return this.isEmulateDiskRotation;
    }

    public boolean isEmulateDriveCPU() {
        return this.isEmulateDriveCPU;
    }

    public int getEmulationLevel() {
        return this.emulationLevel;
    }

    public final void setEmulationLevel(int level) {
        if (level != this.emulationLevel) {
            String mode = null;
            if (level >= 100) {
                this.isEmulateDriveCPU = true;
                this.isEmulateDC = true;
                this.isEmulateDiskRotation = true;
                mode = "'compatible'";
                this.impl = new C1541FullEmulationImpl(this);
            } else if (level >= 50) {
                this.isEmulateDriveCPU = true;
                this.isEmulateDC = false;
                this.isEmulateDiskRotation = false;
                mode = "'balanced'";
                this.impl = new C1541FullEmulationImpl(this);
            } else {
                this.isEmulateDriveCPU = false;
                this.isEmulateDC = false;
                this.isEmulateDiskRotation = false;
                mode = "'fast'";
                this.impl = new C1541IECBusOnlyImpl(this);
            }
            if (this.getLogger() != null) {
                this.getLogger().info("Setting drive #" + (this.getID() + 8) + " emulation " + mode + " mode");
            }
            this.impl.initialize();
            this.cpu.setCycles(0L);
            this.emulationLevel = level;
        }
    }

    public final VIA6522 getVIA(int n) {
        return this.vias[n];
    }

    public final int getID() {
        return this.id;
    }

    public void reset() {
        this.detachImage();
        this.impl.initialize();
        this.impl.reset();
        super.reset();
        this.vias[0].reset();
        this.vias[1].reset();
    }

    public void initialize() {
        this.impl.initialize();
    }

    public void synchronizeWithDevice(EmulatedDevice device) {
        super.synchronizeWithDevice(device);
        this.nextUpdate = device.getCPU().getCycles();
        this.vias[0].synchronizeWithDevice(device);
        this.vias[1].synchronizeWithDevice(device);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void attachImage(InputStream stream, String imageName) throws IOException {
        int b;
        String lcImage = imageName.toLowerCase();
        if (lcImage.indexOf(46) < 0) throw new IOException("Could not determine the file type for the image " + imageName + "!");
        this.detachImage();
        String extension = lcImage.substring(lcImage.lastIndexOf(46) + 1);
        this.driveHandler = (DiskDriveHandler)this.driveHandlers.get(extension);
        if (null == this.driveHandler) throw new IOException("Image type '" + extension + "' not supported!");
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream(175000);
        }
        catch (OutOfMemoryError e) {
            out = new ByteArrayOutputStream();
        }
        while ((b = stream.read()) >= 0) {
            out.write((byte)b);
        }
        this.driveHandler.mount(out.toByteArray());
        out = null;
        this.iecBus.addDevice(this);
        this.iecBus.addObserver(this);
        this.setChanged(true);
        this.notifyObservers(DISK_MOUNTED);
        if (null == this.getLogger()) return;
        this.getLogger().info("Attached disk image '" + this.driveHandler.getLabel().trim() + "' to drive #" + (this.id + 8));
    }

    public void detachImage() {
        if (this.driveHandler != null) {
            if (this.driveHandler.wasModified()) {
                this.setChanged(true);
                this.notifyObservers(this.driveHandler);
            }
            this.driveHandler.destroy();
            this.driveHandler = null;
            this.iecBus.removeDevice(this);
            this.iecBus.deleteObserver(this);
            if (null != this.getLogger()) {
                this.getLogger().info("Detached disk image from drive #" + (this.id + 8));
            }
        }
    }

    public Vector getFilenames() {
        Vector<String> result = new Vector<String>();
        Enumeration en = this.driveHandler.directoryElements();
        while (en.hasMoreElements()) {
            result.addElement(((C64FileEntry)en.nextElement()).filename.trim());
        }
        return result;
    }

    public byte[] readFile(String filename, String fileType) throws IOException {
        this.setChanged(true);
        this.notifyObservers(READING);
        if (null != this.getLogger()) {
            this.getLogger().info("Reading file '" + filename + "'");
        }
        return this.driveHandler.readFile(filename, fileType);
    }

    public byte[] readFile(String filename) throws IOException {
        return this.readFile(filename, null);
    }

    public DiskDriveHandler getDriveHandler() {
        return this.driveHandler;
    }

    public final long getNextUpdate() {
        return this.nextUpdate;
    }

    public void update(long cycles) {
        this.isRunning = true;
        this.isPaused = false;
        this.impl.update(cycles);
    }

    public void run() {
        super.run();
        this.update(Long.MAX_VALUE);
        this.getLogger().info(this.getName() + " ready");
    }

    public void update(Object observed, Object arg) {
        if (observed instanceof DriveHandler) {
            this.setChanged(true);
            this.notifyObservers(arg);
        } else if (observed == this.iecBus) {
            this.impl.update(observed, arg);
        }
    }

    public void serialize(DataOutputStream out) throws IOException {
        if (this.iecBus.getController().getCPU().getCycles() - this.lastActiveCycle <= this.getDeactivationPeriod()) {
            throw new IllegalStateException("Cannot serialize a running floppy drive!");
        }
        SerializationUtils.serialize(out, this.vias);
        out.writeInt(this.emulationLevel);
    }

    public void deserialize(DataInputStream in) throws IOException {
        SerializationUtils.deserialize(in, this.vias);
        this.setEmulationLevel(in.readInt());
    }

    protected CPU6502 createCPU() {
        return new C1541CPU6502(this);
    }

    protected void resetIOChips() {
        this.vias[0].reset();
        this.vias[1].reset();
    }

    protected long getDeactivationPeriod() {
        return 1000000L;
    }

    static {
        SUPPORTED_EXTENSIONS.addElement("d64");
        SUPPORTED_EXTENSIONS.addElement("t64");
        SUPPORTED_EXTENSIONS.addElement("prg");
        SUPPORTED_EXTENSIONS.addElement("p00");
        READING = new Integer(1);
        WRITING = new Integer(2);
        DISK_MOUNTED = new Integer(3);
    }

    public class C1541FullEmulationImpl
    extends C1541Impl {
        private static final int UPDATE_CYCLES = 10;

        public C1541FullEmulationImpl(C1541 c15412) {
            super(c15412);
        }

        public void update(long cycles) {
            this.c1541.nextUpdate = cycles == Long.MAX_VALUE ? Long.MAX_VALUE : cycles + 10L;
            CPU6502 cpu_ = C1541.this.getCPU();
            VIA6522 via0 = this.c1541.getVIA(0);
            VIA6522_DC via1 = (VIA6522_DC)this.c1541.getVIA(1);
            C1541 c1541_ = this.c1541;
            long nextIOUpdate = 0L;
            while (c1541_.isRunning() && (!c1541_.isPaused() || cycles == Long.MAX_VALUE) && cpu_.getCycles() < cycles) {
                cpu_.emulateNextInstruction();
                long floppyCycles = C1541.this.cpu.getCycles();
                if (floppyCycles >= nextIOUpdate) {
                    if (floppyCycles >= via0.getNextUpdate()) {
                        via0.update(floppyCycles);
                    }
                    if (floppyCycles >= via1.getNextUpdate()) {
                        via1.update(floppyCycles);
                    }
                    nextIOUpdate = Math.min(Math.min(floppyCycles + 1000L, via0.getNextUpdate()), via1.getNextUpdate());
                }
                if (!C1541.this.isEmulateDiskRotation() || floppyCycles < via1.nextMove) continue;
                if (via1.isMotorOn()) {
                    via1.rotateDisk();
                }
                via1.nextMove = floppyCycles + 30L;
            }
        }

        public void update(Object observed, Object arg) {
            if (observed == this.c1541.iecBus) {
                ((VIA6522_BC)this.c1541.getVIA(0)).update(observed, arg);
            }
        }
    }

    public class C1541IECBusOnlyImpl
    extends C1541Impl {
        public static final int NUM_CHANNELS = 16;
        private static final int CMD_LISTEN = 32;
        private static final int CMD_UNLISTEN = 48;
        private static final int CMD_TALK = 64;
        private static final int CMD_UNTALK = 80;
        private static final int CMD_DATA = 96;
        private static final int CMD_CLOSE = 224;
        private static final int CMD_OPEN = 240;
        private static final int MODE_READY_TO_LISTEN = 1;
        private static final int MODE_WAIT_FOR_TALKER = 2;
        private static final int MODE_READ = 3;
        private static final int MODE_READY_TO_TALK = 4;
        private static final int MODE_WAIT_FOR_EOI_ACKNOWLEDGE = 5;
        private static final int MODE_WAIT_FOR_LISTENER = 6;
        private static final int MODE_WRITE = 7;
        private static final int MODE_WAIT_FOR_WRITE_ACKNOWLEDGE = 8;
        private static final int MODE_WAIT_FOR_END_OF_EOI_ACKNOWLEDGE = 9;
        private static final int TIMEOUT_SEND_DATA = 1;
        private static final int TIMEOUT_KEEP_WRITE_STEADY = 2;
        private static final int TIMEOUT_WAIT_FOR_TURNAROUND = 3;
        private static final int TIMEOUT_WAIT_FOR_EOI = 4;
        private static final int TIMEOUT_SHOW_EOI_NOTICED = 5;
        private static final int TIMEOUT_WAIT_FOR_WRITE_ACKNOWLEDGE = 6;
        private DriveChannel[] channels;
        private int currentChannel;
        private int iecMode;
        private boolean isUnderATN;
        private long timeoutCycle;
        private int timeoutType;
        private boolean isLastChar;
        private final StringBuffer currentByte;
        private final ByteArrayOutputStream received;
        private boolean hasListener;
        private boolean hasTalker;

        public C1541IECBusOnlyImpl(C1541 c15412) {
            super(c15412);
            this.iecMode = 0;
            this.isUnderATN = false;
            this.timeoutCycle = -1L;
            this.timeoutType = 0;
            this.isLastChar = false;
            this.currentByte = new StringBuffer();
            this.received = new ByteArrayOutputStream();
            this.hasListener = false;
            this.hasTalker = false;
        }

        public void initialize() {
            this.channels = new DriveChannel[16];
            this.channels[15] = new DriveCommandChannel(this.c1541, this.channels);
            this.currentChannel = 0;
        }

        public void reset() {
            this.iecMode = 0;
            this.isUnderATN = false;
            this.timeoutCycle = -1L;
            this.timeoutType = 0;
            this.isLastChar = false;
            this.hasTalker = false;
            this.hasListener = false;
            this.currentByte.delete(0, this.currentByte.length());
            this.received.reset();
            this.c1541.iecBus.setSignal(this.c1541, IECBus.CLK, false);
        }

        public void openChannel(int channel) throws IOException {
            this.currentChannel = channel;
            if (channel == 0) {
                this.channels[channel] = new FileReadDriveChannel(this.c1541);
            } else if (channel == 1) {
                this.channels[channel] = new FileWriteDriveChannel(this.c1541);
            } else if (channel != 15) {
                this.channels[channel] = new MultiPurposeDriveChannel(this.c1541);
            }
        }

        public void setActiveChannel(int channel) {
            this.currentChannel = channel;
            if (15 == channel && this.getActiveChannel() == null) {
                this.channels[15] = new DriveCommandChannel(this.c1541, this.channels);
            }
        }

        public DriveChannel getActiveChannel() {
            return this.getChannel(this.currentChannel);
        }

        public DriveChannel getChannel(int channel) {
            return this.channels[channel];
        }

        public void closeChannel(int channel) {
            try {
                this.channels[channel].close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void stopTransfer() {
            this.iecMode = 0;
            this.isLastChar = false;
            this.timeoutCycle = -1L;
            this.timeoutType = 0;
            this.currentByte.delete(0, this.currentByte.length());
        }

        private void handleATNCommand(int b) {
            int command = b & 0xF0;
            int device = b & 0x1F;
            int secondary = b & 0xF;
            switch (command) {
                case 64: 
                case 80: {
                    if (device == 31) {
                        this.hasTalker = false;
                        this.received.reset();
                        break;
                    }
                    if (device == this.c1541.getID() + 8) {
                        this.hasTalker = true;
                        break;
                    }
                    C1541.this.iecBus.setSignal(this.c1541, IECBus.DATA, false);
                    break;
                }
                case 32: 
                case 48: {
                    if (device == 31) {
                        this.executeListenCommand();
                        this.hasListener = false;
                        this.received.reset();
                        break;
                    }
                    if (device == this.c1541.getID() + 8) {
                        this.received.reset();
                        this.received.write(b);
                        this.hasListener = true;
                        break;
                    }
                    C1541.this.iecBus.setSignal(this.c1541, IECBus.DATA, false);
                    break;
                }
                case 240: {
                    break;
                }
                case 224: {
                    break;
                }
                case 96: {
                    if (this.hasListener || this.hasTalker) {
                        this.setActiveChannel(secondary);
                        break;
                    }
                    throw new RuntimeException("No listener/talker set for DATA command!");
                }
                default: {
                    throw new RuntimeException("Unknown ATN command: " + command + "!");
                }
            }
        }

        private void executeListenCommand() {
            int b;
            int command;
            byte[] bytes = this.received.toByteArray();
            int n = 0;
            if ((command = (b = bytes[n++] & 0xFF) & 0xF0) == 32) {
                b = bytes[n++] & 0xFF;
                command = b & 0xF0;
                int secondary = b & 0xF;
                try {
                    switch (command) {
                        case 240: {
                            this.openChannel(secondary);
                        }
                        case 96: {
                            this.getActiveChannel().write(bytes, n, bytes.length - n - 1);
                            this.getActiveChannel().commit();
                            break;
                        }
                        case 224: {
                            this.closeChannel(secondary);
                            break;
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException("IOException while writing to the IECBus. Command=$" + Integer.toHexString(command) + ", Sec=" + secondary + ".\nThe error message was " + e);
                }
            }
        }

        private final void determineTimeout() {
            this.c1541.nextUpdate = this.timeoutCycle >= 0L ? this.timeoutCycle : Long.MAX_VALUE;
        }

        public void update(Object observed, Object arg) {
            if (observed instanceof IECBus) {
                IECBus iecBus = (IECBus)observed;
                EmulatedDevice controller = iecBus.getController();
                boolean isATNOut = iecBus.getSignal(controller, IECBus.ATN);
                boolean isCLKOut = iecBus.getSignal(controller, IECBus.CLK);
                boolean isDATAOut = iecBus.getSignal(controller, IECBus.DATA);
                if (isATNOut && !this.isUnderATN) {
                    this.stopTransfer();
                }
                switch (this.iecMode) {
                    case 8: {
                        if (!isDATAOut) break;
                        this.iecMode = 4;
                        this.timeoutCycle = iecBus.getController().getCPU().getCycles() + 100L;
                        this.timeoutType = 1;
                        break;
                    }
                    case 7: {
                        try {
                            int bitPos;
                            if (this.currentByte.length() == 0) {
                                int b = this.getActiveChannel().read();
                                if (b < 0) {
                                    throw new IOException("End of data channel!");
                                }
                                this.currentByte.append(Integer.toBinaryString(b));
                                if (this.currentByte.length() < 8) {
                                    this.currentByte.insert(0, "0000000".substring(0, 8 - this.currentByte.length()));
                                }
                            }
                            boolean bit = this.currentByte.charAt(bitPos = this.currentByte.length() - 1) == '0';
                            this.currentByte.deleteCharAt(bitPos);
                            iecBus.setSignal(this.c1541, IECBus.DATA, bit);
                            iecBus.setSignal(this.c1541, IECBus.CLK, false);
                            this.timeoutCycle = controller.getCPU().getCycles() + 100L;
                            this.timeoutType = 2;
                        }
                        catch (IOException e) {
                            iecBus.setSignal(this.c1541, IECBus.CLK, false);
                            iecBus.setSignal(this.c1541, IECBus.DATA, false);
                            this.stopTransfer();
                        }
                        break;
                    }
                    case 9: {
                        if (isDATAOut) break;
                        iecBus.setSignal(this.c1541, IECBus.CLK, true);
                        this.iecMode = 7;
                        this.timeoutCycle = controller.getCPU().getCycles() + 100L;
                        this.timeoutType = 1;
                        break;
                    }
                    case 5: {
                        if (!isDATAOut) break;
                        this.iecMode = 9;
                        break;
                    }
                    case 6: {
                        if (isDATAOut) break;
                        try {
                            if (this.getActiveChannel().available() != 1) {
                                iecBus.setSignal(this.c1541, IECBus.CLK, true);
                                this.iecMode = 7;
                                this.timeoutCycle = controller.getCPU().getCycles() + 100L;
                                this.timeoutType = 1;
                                break;
                            }
                            this.iecMode = 5;
                        }
                        catch (IOException e) {
                            this.stopTransfer();
                        }
                        catch (NullPointerException e) {
                            this.stopTransfer();
                        }
                        break;
                    }
                    case 4: {
                        iecBus.setSignal(this.c1541, IECBus.CLK, false);
                        this.iecMode = 6;
                        break;
                    }
                    case 3: {
                        if (isCLKOut) break;
                        this.currentByte.insert(0, isDATAOut ? (char)'0' : '1');
                        this.iecMode = 2;
                        break;
                    }
                    case 2: {
                        if (!isCLKOut) break;
                        this.timeoutCycle = -1L;
                        this.timeoutType = 0;
                        if (this.currentByte.length() == 8) {
                            if (isDATAOut) break;
                            iecBus.setSignal(this.c1541, IECBus.DATA, true);
                            int b = Integer.parseInt(this.currentByte.toString(), 2);
                            this.received.write(b);
                            this.currentByte.delete(0, this.currentByte.length());
                            if (isATNOut) {
                                this.handleATNCommand(b);
                            }
                            this.iecMode = 1;
                            if (!this.isLastChar) break;
                            this.isLastChar = false;
                            break;
                        }
                        this.iecMode = 3;
                        break;
                    }
                    case 1: {
                        if (!isCLKOut && !isATNOut && isDATAOut && this.hasTalker) {
                            iecBus.setSignal(this.c1541, IECBus.DATA, false);
                            this.timeoutCycle = controller.getCPU().getCycles() + 50L;
                            this.timeoutType = 3;
                            this.iecMode = 4;
                            break;
                        }
                        if (isCLKOut) break;
                        iecBus.setSignal(this.c1541, IECBus.DATA, false);
                        this.timeoutCycle = controller.getCPU().getCycles() + 200L;
                        this.timeoutType = 4;
                        this.iecMode = 2;
                        break;
                    }
                    default: {
                        if (!isCLKOut || !isATNOut && !this.hasListener || this.c1541.getDriveHandler() == null) break;
                        iecBus.setSignal(this.c1541, IECBus.DATA, true);
                        this.iecMode = 1;
                    }
                }
                this.isUnderATN = isATNOut;
                this.determineTimeout();
            }
        }

        public void update(long cycles) {
            if (cycles >= this.timeoutCycle) {
                IECBus iecBus = this.c1541.iecBus;
                switch (this.timeoutType) {
                    case 4: {
                        iecBus.setSignal(this.c1541, IECBus.DATA, true);
                        this.timeoutCycle = cycles + 100L;
                        this.timeoutType = 5;
                        break;
                    }
                    case 5: {
                        this.timeoutCycle = -1L;
                        this.timeoutType = 0;
                        iecBus.setSignal(this.c1541, IECBus.DATA, false);
                        this.isLastChar = true;
                        break;
                    }
                    case 2: {
                        iecBus.setSignal(this.c1541, IECBus.CLK, true);
                        if (this.currentByte.length() == 0) {
                            iecBus.setSignal(this.c1541, IECBus.DATA, false);
                            this.timeoutCycle = iecBus.getController().getCPU().getCycles() + 1000L;
                            this.timeoutType = 6;
                            this.iecMode = 8;
                            break;
                        }
                        this.timeoutCycle = iecBus.getController().getCPU().getCycles() + 70L;
                        this.timeoutType = 1;
                        break;
                    }
                    case 1: {
                        this.timeoutCycle = -1L;
                        this.timeoutType = 0;
                        this.update(iecBus, null);
                        break;
                    }
                    case 6: {
                        this.timeoutCycle = -1L;
                        this.timeoutType = 0;
                        iecBus.setSignal(this.c1541, IECBus.CLK, false);
                        this.stopTransfer();
                        break;
                    }
                    case 3: {
                        iecBus.setSignal(this.c1541, IECBus.CLK, true);
                        this.timeoutCycle = iecBus.getController().getCPU().getCycles() + 100L;
                        this.timeoutType = 1;
                    }
                }
                this.determineTimeout();
            }
        }
    }

    public abstract class C1541Impl
    implements Observer {
        protected final C1541 c1541;

        public C1541Impl(C1541 c15412) {
            this.c1541 = c15412;
        }

        public void initialize() {
        }

        public void reset() {
        }

        public abstract void update(long var1);
    }
}

